/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class GraphDatabaseDependencies
implements InternalAbstractGraphDatabase.Dependencies {
    private final Monitors monitors;
    private final LogProvider userLogProvider;
    private final List<Class<?>> settingsClasses;
    private final List<KernelExtensionFactory<?>> kernelExtensions;
    private final List<QueryEngineProvider> queryEngineProviders;

    public static GraphDatabaseDependencies newDependencies() {
        ArrayList kernelExtensions = new ArrayList();
        for (KernelExtensionFactory factory : Service.load(KernelExtensionFactory.class)) {
            kernelExtensions.add(factory);
        }
        return new GraphDatabaseDependencies(null, null, new ArrayList(), kernelExtensions, Iterables.toList(Service.load(QueryEngineProvider.class)));
    }

    private GraphDatabaseDependencies(Monitors monitors, LogProvider userLogProvider, List<Class<?>> settingsClasses, List<KernelExtensionFactory<?>> kernelExtensions, List<QueryEngineProvider> queryEngineProviders) {
        this.monitors = monitors;
        this.userLogProvider = userLogProvider;
        this.settingsClasses = settingsClasses;
        this.kernelExtensions = kernelExtensions;
        this.queryEngineProviders = queryEngineProviders;
    }

    public GraphDatabaseDependencies monitors(Monitors monitors) {
        return new GraphDatabaseDependencies(monitors, this.userLogProvider, this.settingsClasses, this.kernelExtensions, this.queryEngineProviders);
    }

    public GraphDatabaseDependencies userLogProvider(LogProvider userLogProvider) {
        return new GraphDatabaseDependencies(this.monitors, userLogProvider, this.settingsClasses, this.kernelExtensions, this.queryEngineProviders);
    }

    public GraphDatabaseDependencies settingsClasses(List<Class<?>> settingsClasses) {
        return new GraphDatabaseDependencies(this.monitors, this.userLogProvider, settingsClasses, this.kernelExtensions, this.queryEngineProviders);
    }

    public GraphDatabaseDependencies settingsClasses(Class<?> ... settingsClass) {
        this.settingsClasses.addAll(Arrays.asList(settingsClass));
        return new GraphDatabaseDependencies(this.monitors, this.userLogProvider, this.settingsClasses, this.kernelExtensions, this.queryEngineProviders);
    }

    public GraphDatabaseDependencies kernelExtensions(Iterable<KernelExtensionFactory<?>> kernelExtensions) {
        return new GraphDatabaseDependencies(this.monitors, this.userLogProvider, this.settingsClasses, Iterables.addAll(new ArrayList(), kernelExtensions), this.queryEngineProviders);
    }

    public GraphDatabaseDependencies queryEngineProviders(Iterable<QueryEngineProvider> queryEngineProviders) {
        return new GraphDatabaseDependencies(this.monitors, this.userLogProvider, this.settingsClasses, this.kernelExtensions, Iterables.addAll(this.queryEngineProviders, queryEngineProviders));
    }

    @Override
    public Monitors monitors() {
        return this.monitors;
    }

    @Override
    public LogProvider userLogProvider() {
        return this.userLogProvider;
    }

    @Override
    public Iterable<Class<?>> settingsClasses() {
        return this.settingsClasses;
    }

    @Override
    public Iterable<KernelExtensionFactory<?>> kernelExtensions() {
        return this.kernelExtensions;
    }

    @Override
    public Iterable<QueryEngineProvider> executionEngines() {
        return this.queryEngineProviders;
    }
}

