/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.impl.notification;

import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.kernel.api.exceptions.Status;

public enum NotificationCode {
    CARTESIAN_PRODUCT(SeverityLevel.WARNING, Status.Statement.CartesianProduct, "If a part of a query contains multiple disconnected patterns, this will build a cartesian product between all those parts. This may produce a large amount of data and slow down query processing. While occasionally intended, it may often be possible to reformulate the query that avoids the use of this cross product, perhaps by adding a relationship between the different parts or by using OPTIONAL MATCH"),
    LEGACY_PLANNER(SeverityLevel.WARNING, Status.Statement.DeprecationWarning, "Using PLANNER for switching between planners has been deprecated, please use CYPHER planner=[rule,cost] instead");

    private final Status status;
    private final String description;
    private final SeverityLevel severity;

    private NotificationCode(SeverityLevel severity, Status status, String description) {
        this.severity = severity;
        this.status = status;
        this.description = description;
    }

    public Notification notification(InputPosition position) {
        return new Notification(position);
    }

    private final class Notification
    implements org.neo4j.graphdb.Notification {
        private final InputPosition position;

        public Notification(InputPosition position) {
            this.position = position;
        }

        @Override
        public String getCode() {
            return NotificationCode.this.status.code().serialize();
        }

        @Override
        public String getTitle() {
            return NotificationCode.this.status.code().description();
        }

        @Override
        public String getDescription() {
            return NotificationCode.this.description;
        }

        @Override
        public InputPosition getPosition() {
            return this.position;
        }

        @Override
        public SeverityLevel getSeverity() {
            return NotificationCode.this.severity;
        }
    }
}

