/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.helpers.Settings;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.GraphDatabaseConfigurationMigrator;
import org.neo4j.kernel.configuration.Internal;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.kernel.configuration.Obsoleted;
import org.neo4j.kernel.configuration.Title;
import org.neo4j.kernel.impl.cache.MonitorGc;

public abstract class GraphDatabaseSettings {
    @Migrator
    private static final ConfigurationMigrator migrator = new GraphDatabaseConfigurationMigrator();
    @Title(value="Read only database")
    @Description(value="Only allow read operations from this Neo4j instance. This mode still requires write access to the directory for lock purposes.")
    public static final Setting<Boolean> read_only = Settings.setting("read_only", Settings.BOOLEAN, "false");
    @Description(value="Print out the effective Neo4j configuration after startup.")
    public static final Setting<Boolean> dump_configuration = Settings.setting("dump_configuration", Settings.BOOLEAN, "false");
    @Description(value="Whether to allow a store upgrade in case the current version of the database starts against an older store version. Setting this to `true` does not guarantee successful upgrade, it just allows an upgrade to be performed.")
    public static final Setting<Boolean> allow_store_upgrade = Settings.setting("allow_store_upgrade", Settings.BOOLEAN, "false");
    @Description(value="Determines whether any TransactionInterceptors loaded will intercept externally received transactions (for example in HA) before they reach the logical log and are applied to the store.")
    @Internal
    public static final Setting<Boolean> intercept_deserialized_transactions = Settings.setting("intercept_deserialized_transactions", Settings.BOOLEAN, "false");
    @Description(value="Set this to specify the default parser.")
    public static final Setting<String> cypher_parser_version = Settings.setting("cypher_parser_version", Settings.options("1.9", "2.0", "2.1", "2.2", "2.3"), Settings.NO_DEFAULT);
    @Description(value="Set this to specify the default planner.")
    public static final Setting<String> cypher_planner = Settings.setting("dbms.cypher.planner", Settings.options("COST", "RULE"), Settings.NO_DEFAULT);
    @Internal
    public static final Setting<String> cypher_runtime = Settings.setting("dbms.cypher.runtime", Settings.options("INTERPRETED", "COMPILED"), Settings.NO_DEFAULT);
    @Description(value="The number of Cypher query execution plans that are cached.")
    public static Setting<Integer> query_cache_size = Settings.setting("query_cache_size", Settings.INTEGER, "1000", Settings.min(0));
    @Description(value="The minimum lifetime of a query plan before a query is considered for replanning")
    public static Setting<Long> cypher_min_replan_interval = Settings.setting("dbms.cypher.min_replan_interval", Settings.DURATION, "1s");
    @Description(value="Determines if Cypher will allow using file URLs when loading data using `LOAD CSV`. Setting this value to `false` will cause Neo4j to fail `LOAD CSV` clauses that load data from the file system.")
    public static Setting<Boolean> allow_file_urls = Settings.setting("allow_file_urls", Settings.BOOLEAN, "true");
    @Description(value="The directory where the database files are located.")
    public static final Setting<File> store_dir = Settings.setting("store_dir", Settings.PATH, Settings.NO_DEFAULT);
    @Description(value="The maximum amount of time to wait for the database to become available, when starting a new transaction.")
    @Internal
    public static final Setting<Long> transaction_start_timeout = Settings.setting("transaction_start_timeout", Settings.DURATION, "1s");
    @Description(value="The base name for the Neo4j Store files, either an absolute path or relative to the store_dir setting. This should generally not be changed.")
    @Internal
    public static final Setting<File> neo_store = Settings.setting("neo_store", Settings.PATH, "neostore", Settings.basePath(store_dir));
    @Description(value="Threshold for rotation of the internal log.")
    public static final Setting<Long> store_internal_log_rotation_threshold = Settings.setting("store.internal_log.rotation_threshold", Settings.BYTES, "20m", Settings.min(0L), Settings.max(Long.MAX_VALUE));
    @Description(value="Minimum time (in seconds) after last rotation of the internal log before it may be rotated again.")
    public static final Setting<Integer> store_internal_log_rotation_delay = Settings.setting("store.internal_log.rotation_threshold", Settings.INTEGER, "300", Settings.min(0), Settings.max(Integer.MAX_VALUE));
    @Description(value="Maximum number of history files for the internal log.")
    public static final Setting<Integer> store_internal_log_archive_count = Settings.setting("store.internal_log.archive_count", Settings.INTEGER, "7", Settings.min(1));
    @Description(value="Controls the auto indexing feature for nodes. Setting it to `false` shuts it down, while `true` enables it by default for properties listed in the node_keys_indexable setting.")
    public static final Setting<Boolean> node_auto_indexing = Settings.setting("node_auto_indexing", Settings.BOOLEAN, "false");
    @Description(value="A list of property names (comma separated) that will be indexed by default. This applies to _nodes_ only.")
    public static final Setting<String> node_keys_indexable = Settings.setting("node_keys_indexable", Settings.STRING, Settings.NO_DEFAULT, Settings.illegalValueMessage("must be a comma-separated list of keys to be indexed", Settings.matches(".+")));
    @Description(value="Controls the auto indexing feature for relationships. Setting it to `false` shuts it down, while `true` enables it by default for properties listed in the relationship_keys_indexable setting.")
    public static final Setting<Boolean> relationship_auto_indexing = Settings.setting("relationship_auto_indexing", Settings.BOOLEAN, "false");
    @Description(value="A list of property names (comma separated) that will be indexed by default. This applies to _relationships_ only.")
    public static final Setting<String> relationship_keys_indexable = Settings.setting("relationship_keys_indexable", Settings.STRING, Settings.NO_DEFAULT, Settings.illegalValueMessage("must be a comma-separated list of keys to be indexed", Settings.matches(".+")));
    @Description(value="Enable or disable background index sampling")
    public static final Setting<Boolean> index_background_sampling_enabled = Settings.setting("index_background_sampling_enabled", Settings.BOOLEAN, "true");
    @Description(value="Size of buffer used by index sampling")
    public static final Setting<Long> index_sampling_buffer_size = Settings.setting("index_sampling_buffer_size", Settings.BYTES, "64m", Settings.min(0x100000L), Settings.max(Integer.MAX_VALUE));
    @Description(value="Percentage of index updates of total index size required before sampling of a given index is triggered")
    public static final Setting<Integer> index_sampling_update_percentage = Settings.setting("index_sampling_update_percentage", Settings.INTEGER, "5", Settings.min(0));
    @Description(value="The maximum number of open Lucene index searchers.")
    public static Setting<Integer> lucene_searcher_cache_size = Settings.setting("lucene_searcher_cache_size", Settings.INTEGER, Integer.toString(Integer.MAX_VALUE), Settings.min(1));
    @Description(value="Make Neo4j keep the logical transaction logs for being able to backup the database. Can be used for specifying the threshold to prune logical logs after. For example \"10 days\" will prune logical logs that only contains transactions older than 10 days from the current time, or \"100k txs\" will keep the 100k latest transactions and prune any older transactions.")
    public static final Setting<String> keep_logical_logs = Settings.setting("keep_logical_logs", Settings.STRING, "7 days", Settings.illegalValueMessage("must be `true`/`false` or of format '<number><optional unit> <type>' for example `100M size` for limiting logical log space on disk to 100Mb, or `200k txs` for limiting the number of transactions to keep to 200 000", Settings.matches(".+")));
    @Description(value="Specifies at which file size the logical log will auto-rotate. `0` means that no rotation will automatically occur based on file size. ")
    public static final Setting<Long> logical_log_rotation_threshold = Settings.setting("logical_log_rotation_threshold", Settings.BYTES, "250M", Settings.min(0x100000L));
    @Description(value="Use a quick approach for rebuilding the ID generators. This give quicker recovery time, but will limit the ability to reuse the space of deleted entities.")
    @Internal
    public static final Setting<Boolean> rebuild_idgenerators_fast = Settings.setting("rebuild_idgenerators_fast", Settings.BOOLEAN, "true");
    @Deprecated
    @Obsoleted(value="This setting has been obsoleted. Neo4j no longer relies on the memory-mapping capabilities of the operating system.")
    @Description(value="Use memory mapped buffers for accessing the native storage layer.")
    public static final Setting<Boolean> use_memory_mapped_buffers = Settings.setting("use_memory_mapped_buffers", Settings.BOOLEAN, Boolean.toString(!Settings.osIsWindows()));
    @Description(value="Target size for pages of mapped memory.")
    @Internal
    public static final Setting<Long> mapped_memory_page_size = Settings.setting("dbms.pagecache.pagesize", Settings.BYTES, "8192");
    @Description(value="The amount of memory to use for mapping the store files, in bytes (or kilobytes with the 'k' suffix, megabytes with 'm' and gigabytes with 'g'). If Neo4j is running on a dedicated server, then it is generally recommended to leave about 2-4 gigabytes for the operating system, give the JVM enough heap to hold all your transaction state and query context, and then leave the rest for the page cache. The default page cache memory assumes the machine is dedicated to running Neo4j, and is heuristically set to 75% of RAM minus the max Java heap size.")
    public static final Setting<Long> pagecache_memory = Settings.setting("dbms.pagecache.memory", Settings.BYTES, GraphDatabaseSettings.defaultPageCacheMemory(), Settings.min(16384L));
    @Deprecated
    @Obsoleted(value="This is no longer used")
    @Description(value="Log memory mapping statistics regularly.")
    public static final Setting<Boolean> log_mapped_memory_stats = Settings.setting("log_mapped_memory_stats", Settings.BOOLEAN, "false");
    @Deprecated
    @Obsoleted(value="This is no longer used")
    @Description(value="The file where memory mapping statistics will be recorded.")
    public static final Setting<File> log_mapped_memory_stats_filename = Settings.setting("log_mapped_memory_stats_filename", Settings.PATH, "mapped_memory_stats.log", Settings.basePath(store_dir));
    @Deprecated
    @Obsoleted(value="This is no longer used")
    @Description(value="The number of records to be loaded between regular logging of memory mapping statistics.")
    public static final Setting<Integer> log_mapped_memory_stats_interval = Settings.setting("log_mapped_memory_stats_interval", Settings.INTEGER, "1000000");
    @Deprecated
    @Obsoleted(value="Replaced by the dbms.pagecache.memory setting.")
    @Description(value="The size to allocate for memory mapping the node store.")
    public static final Setting<Long> nodestore_mapped_memory_size = Settings.setting("neostore.nodestore.db.mapped_memory", Settings.BYTES, Settings.NO_DEFAULT);
    @Deprecated
    @Obsoleted(value="Replaced by the dbms.pagecache.memory setting.")
    @Description(value="The size to allocate for memory mapping the property value store.")
    public static final Setting<Long> nodestore_propertystore_mapped_memory_size = Settings.setting("neostore.propertystore.db.mapped_memory", Settings.BYTES, Settings.NO_DEFAULT);
    @Deprecated
    @Obsoleted(value="Replaced by the dbms.pagecache.memory setting.")
    @Description(value="The size to allocate for memory mapping the store for property key indexes.")
    public static final Setting<Long> nodestore_propertystore_index_mapped_memory_size = Settings.setting("neostore.propertystore.db.index.mapped_memory", Settings.BYTES, Settings.NO_DEFAULT);
    @Obsoleted(value="Replaced by the dbms.pagecache.memory setting.")
    @Deprecated
    @Description(value="The size to allocate for memory mapping the store for property key strings.")
    public static final Setting<Long> nodestore_propertystore_index_keys_mapped_memory_size = Settings.setting("neostore.propertystore.db.index.keys.mapped_memory", Settings.BYTES, Settings.NO_DEFAULT);
    @Deprecated
    @Obsoleted(value="Replaced by the dbms.pagecache.memory setting.")
    @Description(value="The size to allocate for memory mapping the string property store.")
    public static final Setting<Long> strings_mapped_memory_size = Settings.setting("neostore.propertystore.db.strings.mapped_memory", Settings.BYTES, Settings.NO_DEFAULT);
    @Deprecated
    @Obsoleted(value="Replaced by the dbms.pagecache.memory setting.")
    @Description(value="The size to allocate for memory mapping the array property store.")
    public static final Setting<Long> arrays_mapped_memory_size = Settings.setting("neostore.propertystore.db.arrays.mapped_memory", Settings.BYTES, Settings.NO_DEFAULT);
    @Deprecated
    @Obsoleted(value="Replaced by the dbms.pagecache.memory setting.")
    @Description(value="The size to allocate for memory mapping the relationship store.")
    public static final Setting<Long> relationshipstore_mapped_memory_size = Settings.setting("neostore.relationshipstore.db.mapped_memory", Settings.BYTES, Settings.NO_DEFAULT);
    @Description(value="How many relationships to read at a time during iteration")
    public static final Setting<Integer> relationship_grab_size = Settings.setting("relationship_grab_size", Settings.INTEGER, "100", Settings.min(1));
    @Description(value="Specifies the block size for storing strings. This parameter is only honored when the store is created, otherwise it is ignored. Note that each character in a string occupies two bytes, meaning that a block size of 120 (the default size) will hold a 60 character long string before overflowing into a second block. Also note that each block carries an overhead of 8 bytes. This means that if the block size is 120, the size of the stored records will be 128 bytes.")
    @Internal
    public static final Setting<Integer> string_block_size = Settings.setting("string_block_size", Settings.INTEGER, "120", Settings.min(1));
    @Description(value="Specifies the block size for storing arrays. This parameter is only honored when the store is created, otherwise it is ignored. The default block size is 120 bytes, and the overhead of each block is the same as for string blocks, i.e., 8 bytes.")
    @Internal
    public static final Setting<Integer> array_block_size = Settings.setting("array_block_size", Settings.INTEGER, "120", Settings.min(1));
    @Description(value="Specifies the block size for storing labels exceeding in-lined space in node record. This parameter is only honored when the store is created, otherwise it is ignored. The default block size is 60 bytes, and the overhead of each block is the same as for string blocks, i.e., 8 bytes.")
    @Internal
    public static final Setting<Integer> label_block_size = Settings.setting("label_block_size", Settings.INTEGER, "60", Settings.min(1));
    @Description(value="An identifier that uniquely identifies this graph database instance within this JVM. Defaults to an auto-generated number depending on how many instance are started in this JVM.")
    @Internal
    public static final Setting<String> forced_kernel_id = Settings.setting("forced_kernel_id", Settings.STRING, Settings.NO_DEFAULT, Settings.illegalValueMessage("has to be a valid kernel identifier", Settings.matches("[a-zA-Z0-9]*")));
    @Internal
    public static final Setting<Boolean> execution_guard_enabled = Settings.setting("execution_guard_enabled", Settings.BOOLEAN, "false");
    @Description(value="Amount of time in ms the GC monitor thread will wait before taking another measurement.")
    @Internal
    public static final Setting<Long> gc_monitor_interval = MonitorGc.Configuration.gc_monitor_wait_time;
    @Description(value="The amount of time in ms the monitor thread has to be blocked before logging a message it was blocked.")
    @Internal
    public static final Setting<Long> gc_monitor_block_threshold = MonitorGc.Configuration.gc_monitor_threshold;
    @Description(value="Relationship count threshold for considering a node to be dense")
    public static final Setting<Integer> dense_node_threshold = Settings.setting("dense_node_threshold", Settings.INTEGER, "50", Settings.min(1));
    @Description(value="Whether or not transactions are appended to the log in batches")
    public static final Setting<Boolean> batched_writes = Settings.setting("batched_writes", Settings.BOOLEAN, Boolean.TRUE.toString());
    @Description(value="Log executed queries that takes longer than the configured threshold.")
    public static final Setting<Boolean> log_queries = Settings.setting("dbms.querylog.enabled", Settings.BOOLEAN, "false");
    @Description(value="The file where queries will be recorded.")
    public static final Setting<File> log_queries_filename = Settings.setting("dbms.querylog.filename", Settings.PATH, "queries.log", Settings.basePath(store_dir));
    @Description(value="If the execution of query takes more time than this threshold, the query is logged - provided query logging is enabled. Defaults to 0 seconds, that is all queries are logged.")
    public static final Setting<Long> log_queries_threshold = Settings.setting("dbms.querylog.threshold", Settings.DURATION, "0s");

    private static String defaultPageCacheMemory() {
        String defaultMemoryOverride = System.getProperty("dbms.pagecache.memory.default.override");
        if (defaultMemoryOverride != null) {
            return defaultMemoryOverride;
        }
        long maxHeapMemory = Runtime.getRuntime().maxMemory();
        if (0L < maxHeapMemory && maxHeapMemory < Long.MAX_VALUE) {
            try {
                OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
                Method getTotalPhysicalMemorySize = os.getClass().getMethod("getTotalPhysicalMemorySize", new Class[0]);
                getTotalPhysicalMemorySize.setAccessible(true);
                long physicalMemory = (Long)getTotalPhysicalMemorySize.invoke((Object)os, new Object[0]);
                if (0L < physicalMemory && physicalMemory < Long.MAX_VALUE && maxHeapMemory < physicalMemory) {
                    long heuristic = (long)((double)(physicalMemory - maxHeapMemory) * 0.75);
                    long min = 0x2000000L;
                    long max = 0x10000000000L;
                    long memory = Math.min(max, Math.max(min, heuristic));
                    return String.valueOf(memory);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "2g";
    }
}

