/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

public class GraphDatabaseFactory {
    private final GraphDatabaseFactoryState state;

    public GraphDatabaseFactory() {
        this(new GraphDatabaseFactoryState());
    }

    protected GraphDatabaseFactory(GraphDatabaseFactoryState state) {
        this.state = state;
    }

    protected GraphDatabaseFactoryState getCurrentState() {
        return this.state;
    }

    protected GraphDatabaseFactoryState getStateCopy() {
        return new GraphDatabaseFactoryState(this.getCurrentState());
    }

    public GraphDatabaseService newEmbeddedDatabase(String path) {
        return this.newEmbeddedDatabaseBuilder(path).newGraphDatabase();
    }

    public GraphDatabaseBuilder newEmbeddedDatabaseBuilder(String path) {
        GraphDatabaseFactoryState state = this.getStateCopy();
        GraphDatabaseBuilder.DatabaseCreator creator = this.createDatabaseCreator(path, state);
        GraphDatabaseBuilder builder = this.createGraphDatabaseBuilder(creator);
        this.configure(builder);
        return builder;
    }

    protected GraphDatabaseBuilder createGraphDatabaseBuilder(GraphDatabaseBuilder.DatabaseCreator creator) {
        return new GraphDatabaseBuilder(creator);
    }

    protected GraphDatabaseBuilder.DatabaseCreator createDatabaseCreator(final String path, final GraphDatabaseFactoryState state) {
        return new GraphDatabaseBuilder.DatabaseCreator(){

            @Override
            public GraphDatabaseService newDatabase(Map<String, String> config) {
                config.put("ephemeral", "false");
                InternalAbstractGraphDatabase.Dependencies dependencies = state.databaseDependencies();
                return GraphDatabaseFactory.this.newDatabase(path, config, dependencies);
            }
        };
    }

    protected void configure(GraphDatabaseBuilder builder) {
    }

    protected GraphDatabaseService newDatabase(String path, Map<String, String> config, InternalAbstractGraphDatabase.Dependencies dependencies) {
        return new EmbeddedGraphDatabase(path, config, dependencies);
    }

    @Deprecated
    public Iterable<KernelExtensionFactory<?>> getKernelExtension() {
        return this.getCurrentState().getKernelExtension();
    }

    @Deprecated
    public GraphDatabaseFactory addKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        this.getCurrentState().addKernelExtensions(newKernelExtensions);
        return this;
    }

    @Deprecated
    public GraphDatabaseFactory addKernelExtension(KernelExtensionFactory<?> newKernelExtension) {
        List<KernelExtensionFactory<?>> extensions = Arrays.asList(newKernelExtension);
        return this.addKernelExtensions(extensions);
    }

    @Deprecated
    public GraphDatabaseFactory setKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        this.getCurrentState().setKernelExtensions(newKernelExtensions);
        return this;
    }

    public GraphDatabaseFactory setUserLogProvider(LogProvider userLogProvider) {
        this.getCurrentState().setUserLogProvider(userLogProvider);
        return this;
    }

    public GraphDatabaseFactory setMonitors(Monitors monitors) {
        this.getCurrentState().setMonitors(monitors);
        return this;
    }
}

