/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntLongMap;
import org.neo4j.kernel.impl.core.FirstRelationshipIds;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.kernel.impl.util.RelIdArray;

public class RecordStateForCacheAccessor {
    private final RecordAccessSet access;

    public RecordStateForCacheAccessor(RecordAccessSet access) {
        this.access = access;
    }

    public boolean isDense(long nodeId) {
        return this.access.getNodeRecords().getOrLoad(nodeId, null).forReadingLinkage().isDense();
    }

    public FirstRelationshipIds firstRelationshipIdsOf(long nodeId) {
        final NodeRecord node = this.access.getNodeRecords().getOrLoad(nodeId, null).forReadingLinkage();
        if (!node.isDense()) {
            return new FirstRelationshipIds(){

                @Override
                public long firstIdOf(int type, RelIdArray.DirectionWrapper direction) {
                    return node.getNextRel();
                }
            };
        }
        final PrimitiveIntLongMap ids = Primitive.intLongMap();
        long groupId = node.getNextRel();
        while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipGroupRecord group = this.access.getRelGroupRecords().getOrLoad(groupId, null).forReadingData();
            for (RelIdArray.DirectionWrapper direction : RelIdArray.DirectionWrapper.values()) {
                long firstId = direction.getNextRel(group);
                if (firstId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) continue;
                ids.put(this.typeKey(group.getType(), direction), firstId);
            }
            groupId = group.getNext();
        }
        return new FirstRelationshipIds(){

            @Override
            public long firstIdOf(int type, RelIdArray.DirectionWrapper direction) {
                return ids.get(RecordStateForCacheAccessor.this.typeKey(type, direction));
            }
        };
    }

    private int typeKey(int type, RelIdArray.DirectionWrapper direction) {
        return type * 3 + direction.ordinal();
    }
}

