/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.StringArrayProperty;
import org.neo4j.kernel.impl.cache.SizeOfs;

class CharArrayProperty
extends DefinedProperty {
    final char[] value;

    CharArrayProperty(int propertyKeyId, char[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public char[] value() {
        return (char[])this.value.clone();
    }

    @Override
    public boolean valueEquals(Object other) {
        return CharArrayProperty.valueEquals(this.value, other);
    }

    static boolean valueEquals(char[] value, Object other) {
        if (other instanceof char[]) {
            return Arrays.equals(value, (char[])other);
        }
        if (other instanceof Character[]) {
            Character[] that = (Character[])other;
            if (value.length == that.length) {
                for (int i = 0; i < that.length; ++i) {
                    Character character = that[i];
                    if (character != null && character.charValue() == value[i]) continue;
                    return false;
                }
                return true;
            }
        } else if (other instanceof String[]) {
            return CharArrayProperty.eq((String[])other, value);
        }
        return false;
    }

    @Override
    int valueHash() {
        return CharArrayProperty.hash(this.value);
    }

    static int hash(char[] value) {
        return Arrays.hashCode(value);
    }

    @Override
    boolean hasEqualValue(DefinedProperty other) {
        if (other instanceof CharArrayProperty) {
            CharArrayProperty that = (CharArrayProperty)other;
            return Arrays.equals(this.value, that.value);
        }
        if (other instanceof StringArrayProperty) {
            StringArrayProperty that = (StringArrayProperty)other;
            return CharArrayProperty.eq(that.value, this.value);
        }
        return false;
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(SizeOfs.withReference(SizeOfs.sizeOfArray(this.value)));
    }

    static boolean eq(String[] strings, char[] chars) {
        if (strings.length == chars.length) {
            for (int i = 0; i < strings.length; ++i) {
                String str = strings[i];
                if (str != null && str.length() == 1 && str.charAt(0) == chars[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

