/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.counts.FileVersion;
import org.neo4j.kernel.impl.store.kvstore.Headers;
import org.neo4j.kernel.impl.store.kvstore.MetadataVisitor;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.UnknownKey;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.monitoring.Monitors;

public class DumpCountsStore
implements CountsVisitor,
MetadataVisitor,
UnknownKey.Visitor {
    private static final Token[] NO_TOKENS = new Token[0];
    private final PrintStream out;
    private final Token[] labels;
    private final Token[] relationshipTypes;
    private final Token[] propertyKeys;

    public static void main(String ... args) throws IOException {
        if (args.length != 1) {
            System.err.println("Expecting exactly one argument describing the path to the store");
            System.exit(1);
        }
        DumpCountsStore.dumpCountsStore((FileSystemAbstraction)new DefaultFileSystemAbstraction(), new File(args[0]), System.out);
    }

    public static void dumpCountsStore(FileSystemAbstraction fs, File path, PrintStream out) throws IOException {
        try (PageCache pages = StandalonePageCacheFactory.createPageCache(fs);
             Lifespan life = new Lifespan(new Lifecycle[0]);){
            if (fs.isDirectory(path)) {
                StoreFactory factory = new StoreFactory(fs, path, pages, StringLogger.DEV_NULL, new Monitors());
                life.add(factory.newCountsStore()).accept(new DumpCountsStore(out, factory));
            } else {
                CountsTracker tracker = new CountsTracker(StringLogger.DEV_NULL, fs, pages, new Config(), path);
                if (fs.fileExists(path)) {
                    tracker.visitFile(path, new DumpCountsStore(out));
                } else {
                    life.add(tracker).accept(new DumpCountsStore(out));
                }
            }
        }
    }

    DumpCountsStore(PrintStream out) {
        this(out, NO_TOKENS, NO_TOKENS, NO_TOKENS);
    }

    DumpCountsStore(PrintStream out, StoreFactory factory) {
        this(out, DumpCountsStore.allTokensFrom(factory.newLabelTokenStore()), DumpCountsStore.allTokensFrom(factory.newRelationshipTypeTokenStore()), DumpCountsStore.allTokensFrom(factory.newPropertyKeyTokenStore()));
    }

    private DumpCountsStore(PrintStream out, Token[] labels, Token[] relationshipTypes, Token[] propertyKeys) {
        this.out = out;
        this.labels = labels;
        this.relationshipTypes = relationshipTypes;
        this.propertyKeys = propertyKeys;
    }

    @Override
    public void visitMetadata(File path, Headers headers, int entryCount) {
        FileVersion versionData = headers.get(FileVersion.FILE_VERSION);
        this.out.printf("Counts Store:\t%s%n", path);
        this.out.printf("\ttxId:\t%d%n", versionData.txId);
        this.out.printf("\tminor version:\t%d%n", versionData.minorVersion);
        this.out.printf("\tentries:\t%d%n", entryCount);
        this.out.println("Entries:");
    }

    @Override
    public void visitNodeCount(int labelId, long count) {
        this.out.printf("\tNode[(%s)]:\t%d%n", this.label(labelId), count);
    }

    @Override
    public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
        this.out.printf("\tRelationship[(%s)-%s->(%s)]:\t%d%n", this.label(startLabelId), this.relationshipType(typeId), this.label(endLabelId), count);
    }

    @Override
    public void visitIndexStatistics(int labelId, int propertyKeyId, long updates, long size) {
        this.out.printf("\tIndexStatistics[(%s {%s})]:\tupdates=%d, size=%d%n", this.label(labelId), this.propertyKey(propertyKeyId), updates, size);
    }

    @Override
    public void visitIndexSample(int labelId, int propertyKeyId, long unique, long size) {
        this.out.printf("\tIndexSample[(%s {%s})]:\tunique=%d, size=%d%n", this.label(labelId), this.propertyKey(propertyKeyId), unique, size);
    }

    @Override
    public boolean visitUnknownKey(ReadableBuffer key, ReadableBuffer value) {
        this.out.printf("\t%s:\t%s%n", key, value);
        return true;
    }

    private String label(int id) {
        if (id == -1) {
            return "";
        }
        return DumpCountsStore.token(new StringBuilder(), this.labels, ":", "label", id).toString();
    }

    private String propertyKey(int id) {
        return DumpCountsStore.token(new StringBuilder(), this.propertyKeys, "", "key", id).toString();
    }

    private String relationshipType(int id) {
        if (id == -1) {
            return "";
        }
        return DumpCountsStore.token(new StringBuilder().append('['), this.relationshipTypes, ":", "type", id).append(']').toString();
    }

    private static StringBuilder token(StringBuilder result, Token[] tokens, String pre, String handle, int id) {
        int i;
        Token token = null;
        int n = i = id < tokens.length ? id : tokens.length - 1;
        while (i >= 0 && (token = tokens[i]).id() != id) {
            if (token.id() < id) {
                token = null;
                break;
            }
            --i;
        }
        if (token != null) {
            String name = token.name();
            result.append(pre).append(name).append(" [").append(handle).append("Id=").append(token.id()).append(']');
        } else {
            result.append(handle).append("Id=").append(id);
        }
        return result;
    }

    private static Token[] allTokensFrom(TokenStore<?> store) {
        try (TokenStore<?> tokens = store;){
            Token[] tokenArray = tokens.getTokens(Integer.MAX_VALUE);
            return tokenArray;
        }
    }
}

