/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.StringLogger;

public class ConfiguringPageCacheFactory {
    private final PageSwapperFactory swapperFactory;
    private final Config config;
    private final PageCacheTracer tracer;
    private PageCache pageCache;

    public ConfiguringPageCacheFactory(FileSystemAbstraction fs, Config config, PageCacheTracer tracer) {
        this.swapperFactory = new SingleFilePageSwapperFactory(fs);
        this.config = config;
        this.tracer = tracer;
    }

    public synchronized PageCache getOrCreatePageCache() {
        if (this.pageCache == null) {
            this.pageCache = this.createPageCache();
        }
        return this.pageCache;
    }

    protected PageCache createPageCache() {
        return new MuninnPageCache(this.swapperFactory, this.calculateMaxPages(this.config), this.calculatePageSize(this.config), this.tracer);
    }

    public int calculateMaxPages(Config config) {
        long availableMemory = config.get(GraphDatabaseSettings.pagecache_memory);
        long pageSize = config.get(GraphDatabaseSettings.mapped_memory_page_size);
        long pageCount = availableMemory / pageSize;
        return (int)Math.min(Integer.MAX_VALUE, pageCount);
    }

    public int calculatePageSize(Config config) {
        return config.get(GraphDatabaseSettings.mapped_memory_page_size).intValue();
    }

    public void dumpConfiguration(StringLogger messagesLog) {
        long totalPhysicalMemory = this.totalPhysicalMemory();
        String totalPhysicalMemMb = totalPhysicalMemory == -1L ? "?" : "" + totalPhysicalMemory / 1024L / 1024L;
        long maxVmUsageMb = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        long maxPages = this.calculateMaxPages(this.config);
        long pageSize = this.calculatePageSize(this.config);
        long pageCacheMb = maxPages * pageSize / 1024L / 1024L;
        String msg = "Physical mem: " + totalPhysicalMemMb + " MiB," + " Heap size: " + maxVmUsageMb + " MiB," + " Page cache size: " + pageCacheMb + " MiB.";
        messagesLog.info(msg);
    }

    public long totalPhysicalMemory() {
        try {
            Class<?> beanClass = Thread.currentThread().getContextClassLoader().loadClass("com.sun.management.OperatingSystemMXBean");
            Method method = beanClass.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            return (Long)method.invoke((Object)ManagementFactory.getOperatingSystemMXBean(), new Object[0]);
        }
        catch (Exception | LinkageError e) {
            return -1L;
        }
    }
}

