/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.NoSuchElementException;
import org.neo4j.helpers.Service;

@Deprecated
public class Version
extends Service {
    private final String artifactId;
    private final String title;
    private final String vendor;
    private final String version;
    static final String KERNEL_ARTIFACT_ID = "neo4j-kernel";
    private static final Version KERNEL_VERSION;

    public static Version getKernel() {
        return KERNEL_VERSION;
    }

    public static String getKernelRevision() {
        return Version.getKernel().getRevision();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.title != null) {
            result.append(this.title);
            if (this.artifactId == null || !this.artifactId.equals(this.title)) {
                result.append(" (").append(this.artifactId).append(')');
            }
        } else if (this.artifactId != null) {
            result.append(this.artifactId);
        } else {
            result.append("Unknown Component");
        }
        result.append(", ");
        if (this.title == null) {
            result.append("unpackaged ");
        }
        result.append("version: ").append(this.getVersion());
        return result.toString();
    }

    public final String getVersion() {
        if (this.version == null || this.version.equals("")) {
            return "revision: " + this.getRevision();
        }
        if (this.version.endsWith("-SNAPSHOT")) {
            return this.version + " (revision: " + this.getRevision() + ")";
        }
        return this.version;
    }

    public String getReleaseVersion() {
        return this.version;
    }

    public final String getRevision() {
        StringBuilder result = new StringBuilder(this.getReleaseVersion());
        result.append(':').append(this.getBranchName()).append(':');
        String build = this.getBuildNumber();
        if (!build.startsWith("${") && !build.startsWith("{")) {
            result.append(build).append('/');
        }
        result.append(this.getCommitId());
        return result.toString();
    }

    protected String getBuildNumber() {
        return "{BuildNumber}";
    }

    protected String getCommitId() {
        return "{CommitId}";
    }

    protected String getBranchName() {
        return "{BranchName}";
    }

    protected Version(String artifactId, String version) {
        super(artifactId, new String[0]);
        this.artifactId = artifactId;
        Package pkg = this.getClass().getPackage();
        this.title = Version.defaultValue(pkg.getImplementationTitle(), artifactId);
        this.vendor = Version.defaultValue(pkg.getImplementationVendor(), "Neo Technology");
        this.version = Version.defaultValue(pkg.getImplementationVersion(), version);
    }

    private static String defaultValue(String preferred, String fallback) {
        return preferred == null || preferred.equals("") ? fallback : preferred;
    }

    public static void main(String[] args) {
        Version kernelVersion = Version.getKernel();
        System.out.println(kernelVersion);
        System.out.println("Title: " + kernelVersion.title);
        System.out.println("Vendor: " + kernelVersion.vendor);
        System.out.println("ArtifactId: " + kernelVersion.artifactId);
        System.out.println("Version: " + kernelVersion.getVersion());
        System.out.println("ReleaseVersion: " + kernelVersion.getReleaseVersion());
        System.out.println("Revision: " + kernelVersion.getRevision());
        System.out.println("BuildNumber: " + kernelVersion.getBuildNumber());
        System.out.println("BranchName: " + kernelVersion.getBranchName());
        System.out.println("CommitId: " + kernelVersion.getCommitId());
    }

    static {
        Version kernelVersion;
        try {
            kernelVersion = Service.load(Version.class, KERNEL_ARTIFACT_ID);
        }
        catch (NoSuchElementException ex) {
            kernelVersion = null;
        }
        if (kernelVersion == null) {
            try {
                kernelVersion = (Version)Class.forName("org.neo4j.kernel.impl.ComponentVersion").newInstance();
            }
            catch (Exception e) {
                kernelVersion = null;
            }
        }
        if (kernelVersion == null) {
            kernelVersion = new Version(KERNEL_ARTIFACT_ID, "");
        }
        KERNEL_VERSION = kernelVersion;
    }
}

