/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.impl.util.diffsets.DiffSetsVisitor;

public interface ReadableDiffSets<T> {
    public boolean isAdded(T var1);

    public boolean isRemoved(T var1);

    public Set<T> getAdded();

    public Set<T> getRemoved();

    public boolean isEmpty();

    public Iterator<T> apply(Iterator<T> var1);

    public int delta();

    public PrimitiveLongIterator augment(PrimitiveLongIterator var1);

    public PrimitiveIntIterator augment(PrimitiveIntIterator var1);

    public PrimitiveLongIterator augmentWithRemovals(PrimitiveLongIterator var1);

    public PrimitiveLongIterator augmentWithAdditions(PrimitiveLongIterator var1);

    public ReadableDiffSets<T> filterAdded(Predicate<T> var1);

    public ReadableDiffSets<T> filter(Predicate<T> var1);

    public void accept(DiffSetsVisitor<T> var1);

    public static final class Empty<T>
    implements ReadableDiffSets<T> {
        private static final ReadableDiffSets INSTANCE = new Empty();

        public static <T> ReadableDiffSets<T> instance() {
            return INSTANCE;
        }

        public static <T> ReadableDiffSets<T> ifNull(ReadableDiffSets<T> diffSets) {
            return diffSets == null ? Empty.instance() : diffSets;
        }

        private Empty() {
        }

        @Override
        public boolean isAdded(T elem) {
            return false;
        }

        @Override
        public boolean isRemoved(T elem) {
            return false;
        }

        @Override
        public Set<T> getAdded() {
            return Collections.emptySet();
        }

        @Override
        public Set<T> getRemoved() {
            return Collections.emptySet();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Iterator<T> apply(Iterator<T> source) {
            return source;
        }

        @Override
        public int delta() {
            return 0;
        }

        @Override
        public PrimitiveLongIterator augment(PrimitiveLongIterator source) {
            return source;
        }

        @Override
        public PrimitiveIntIterator augment(PrimitiveIntIterator source) {
            return source;
        }

        @Override
        public PrimitiveLongIterator augmentWithRemovals(PrimitiveLongIterator source) {
            return source;
        }

        @Override
        public PrimitiveLongIterator augmentWithAdditions(PrimitiveLongIterator source) {
            return source;
        }

        @Override
        public ReadableDiffSets<T> filterAdded(Predicate<T> addedFilter) {
            return this;
        }

        @Override
        public ReadableDiffSets<T> filter(Predicate<T> filter) {
            return this;
        }

        @Override
        public void accept(DiffSetsVisitor<T> visitor) {
        }
    }
}

