/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.StoreVersionTrailerUtil;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.HeaderField;
import org.neo4j.kernel.impl.store.kvstore.Headers;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.KeyValueWriter;
import org.neo4j.kernel.impl.store.kvstore.MetadataCollector;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

public abstract class KeyValueStoreFileFormat {
    private final int maxSize;
    private final HeaderField<?>[] headerFields;

    public KeyValueStoreFileFormat(int maxSize, HeaderField<?> ... headerFields) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("Negative maxSize: " + maxSize);
        }
        this.maxSize = maxSize;
        this.headerFields = (HeaderField[])headerFields.clone();
    }

    public final KeyValueStoreFile createStore(FileSystemAbstraction fs, PageCache pages, File path, int keySize, int valueSize, Headers headers, DataProvider data) throws IOException {
        return this.create(Objects.requireNonNull(fs, FileSystemAbstraction.class.getSimpleName()), Objects.requireNonNull(path, "path"), Objects.requireNonNull(pages, PageCache.class.getSimpleName()), keySize, valueSize, Objects.requireNonNull(headers, "headers"), Objects.requireNonNull(data, "data"));
    }

    public final void createEmptyStore(FileSystemAbstraction fs, File path, int keySize, int valueSize, Headers headers) throws IOException {
        this.create(Objects.requireNonNull(fs, FileSystemAbstraction.class.getSimpleName()), Objects.requireNonNull(path, "path"), null, keySize, valueSize, Objects.requireNonNull(headers, "headers"), null);
    }

    public final KeyValueStoreFile openStore(FileSystemAbstraction fs, PageCache pages, File path) throws IOException {
        return this.open(Objects.requireNonNull(fs, FileSystemAbstraction.class.getSimpleName()), Objects.requireNonNull(path, "path"), Objects.requireNonNull(pages, PageCache.class.getSimpleName()));
    }

    protected abstract void writeFormatSpecifier(WritableBuffer var1);

    protected abstract String fileTrailer();

    protected HeaderField<?>[] headerFieldsForFormat(ReadableBuffer formatSpecifier) {
        return (HeaderField[])this.headerFields.clone();
    }

    private MetadataCollector metadata(ReadableBuffer formatSpecifier, int pageSize, int keySize, int valueSize) {
        byte[] format = new byte[formatSpecifier.size()];
        for (int i = 0; i < format.length; ++i) {
            format[i] = formatSpecifier.getByte(i);
        }
        final BigEndianByteArrayBuffer specifier = new BigEndianByteArrayBuffer(format);
        HeaderField[] headerFields = this.headerFieldsForFormat(formatSpecifier);
        return new MetadataCollector(pageSize / (keySize + valueSize), headerFields){

            @Override
            boolean verifyFormatSpecifier(ReadableBuffer value) {
                int size = value.size();
                if (size == specifier.size()) {
                    for (int i = 0; i < size; ++i) {
                        if (value.getByte(i) == specifier.getByte(i)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    /*
     * Exception decompiling
     */
    private KeyValueStoreFile create(FileSystemAbstraction fs, File path, PageCache pages, int keySize, int valueSize, Headers headers, DataProvider dataProvider) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private KeyValueWriter newWriter(FileSystemAbstraction fs, File path, ReadableBuffer formatSpecifier, PageCache pages, int pageSize, int keySize, int valueSize) throws IOException {
        return KeyValueWriter.create(this.metadata(formatSpecifier, pageSize, keySize, valueSize), fs, pages, path, pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyValueStoreFile open(FileSystemAbstraction fs, File path, PageCache pages) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.maxSize * 4]);
        try (StoreChannel file = fs.open(path, "r");){
            while (buffer.hasRemaining()) {
                int bytes = file.read(buffer);
                if (bytes != -1) continue;
                break;
            }
        }
        buffer.flip();
        int keySize = 0;
        while (buffer.hasRemaining() && buffer.get() == 0) {
            if (++keySize <= this.maxSize) continue;
            throw new IOException("Invalid header, key size too large.");
        }
        int valueSize = 1;
        for (int zeros = 0; zeros <= keySize; ++zeros) {
            if (!buffer.hasRemaining()) {
                throw new IOException("Invalid value size: " + valueSize);
            }
            if (buffer.get() != 0) {
                zeros = 0;
            }
            if (++valueSize - keySize <= this.maxSize) continue;
            throw new IOException("Invalid header, value size too large.");
        }
        int pageSize = KeyValueStoreFileFormat.pageSize(pages, keySize, valueSize -= keySize);
        try (PagedFile file = pages.map(path, pageSize);){
            if (StoreVersionTrailerUtil.getTrailerOffset(file, this.fileTrailer()) == -1L) {
                throw new IOException("Invalid file trailer. Expected trailer not found.");
            }
            BigEndianByteArrayBuffer key = new BigEndianByteArrayBuffer(new byte[keySize]);
            BigEndianByteArrayBuffer value = new BigEndianByteArrayBuffer(new byte[valueSize]);
            buffer.position(keySize);
            buffer.limit(keySize + valueSize);
            value.dataFrom(buffer);
            MetadataCollector metadata = this.metadata(value, pageSize, keySize, valueSize);
            KeyValueStoreFile.scanAll(file, 0, metadata, key, value);
            KeyValueStoreFile storeFile = new KeyValueStoreFile(file, keySize, valueSize, metadata);
            file = null;
            KeyValueStoreFile keyValueStoreFile = storeFile;
            return keyValueStoreFile;
        }
    }

    private static int pageSize(PageCache pages, int keySize, int valueSize) {
        int pageSize = pages == null ? 8192 : pages.pageSize();
        pageSize -= pageSize % (keySize + valueSize);
        return pageSize;
    }

    static boolean validFormatSpecifier(byte[] buffer, int keySize) {
        int key = 0;
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == 0) {
                if (i != 0 && ++key != keySize && i != buffer.length - 1) continue;
                return false;
            }
            key = 0;
        }
        return true;
    }
}

