/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;

class NodePropertyCommandsExtractor
extends NeoCommandHandler.Adapter
implements Visitor<Command, IOException> {
    final PrimitiveLongObjectMap<Command.NodeCommand> nodeCommandsById = Primitive.longObjectMap();
    final PrimitiveLongObjectMap<List<Command.PropertyCommand>> propertyCommandsByNodeIds = Primitive.longObjectMap();

    NodePropertyCommandsExtractor() {
    }

    @Override
    public boolean visit(Command element) throws IOException {
        element.handle(this);
        return false;
    }

    public void clear() {
        this.nodeCommandsById.clear();
        this.propertyCommandsByNodeIds.clear();
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        this.nodeCommandsById.put(command.getKey(), (Object)command);
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
        PropertyRecord record = command.getAfter();
        if (record.isNodeSet()) {
            long nodeId = command.getAfter().getNodeId();
            ArrayList<Command.PropertyCommand> group = (ArrayList<Command.PropertyCommand>)this.propertyCommandsByNodeIds.get(nodeId);
            if (group == null) {
                group = new ArrayList<Command.PropertyCommand>();
                this.propertyCommandsByNodeIds.put(nodeId, group);
            }
            group.add(command);
        }
        return false;
    }

    public boolean containsAnyNodeOrPropertyUpdate() {
        return !this.nodeCommandsById.isEmpty() || !this.propertyCommandsByNodeIds.isEmpty();
    }

    public void visitUpdatedNodeIds(PrimitiveLongVisitor<RuntimeException> updatedNodeVisitor) {
        try (PrimitiveLongSet uniqueIds = Primitive.longSet((int)(this.nodeCommandsById.size() + this.propertyCommandsByNodeIds.size()));){
            uniqueIds.addAll(this.nodeCommandsById.iterator());
            uniqueIds.addAll(this.propertyCommandsByNodeIds.iterator());
            uniqueIds.visitKeys(updatedNodeVisitor);
        }
    }
}

