/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.record.NeoStoreUtil;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;

public class ReadOnlyLogVersionRepository
implements LogVersionRepository {
    private final long logVersion;
    private volatile boolean incrementVersionCalled;

    public ReadOnlyLogVersionRepository(FileSystemAbstraction fs, File storeDir) {
        this.logVersion = NeoStoreUtil.neoStoreExists(fs, storeDir) ? new NeoStoreUtil(storeDir, fs).getLogVersion() : 0L;
    }

    @Override
    public long getCurrentLogVersion() {
        if (this.incrementVersionCalled) {
            throw new IllegalStateException("Read-only log version repository has observed a call to incrementVersion, which indicates that it's been shut down");
        }
        return this.logVersion;
    }

    @Override
    public long incrementAndGetVersion() {
        if (this.incrementVersionCalled) {
            throw new IllegalStateException("Read-only log version repository only allows to call incrementVersion once, during shutdown");
        }
        this.incrementVersionCalled = true;
        return this.logVersion;
    }
}

