/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.DuplicateInputIdException;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;

public class BadCollector
implements Collector {
    public static final int BAD_RELATIONSHIPS = 1;
    public static final int DUPLICATE_NODES = 2;
    public static final int COLLECT_ALL = 3;
    private final PrintStream out;
    private final int tolerance;
    private final int collect;
    private long[] leftOverDuplicateNodeIds = new long[10];
    private int leftOverDuplicateNodeIdsCursor = 0;
    private volatile int badEntries;

    public BadCollector(OutputStream out, int tolerance, int collect) {
        this.out = new PrintStream(out);
        this.tolerance = tolerance;
        this.collect = collect;
    }

    @Override
    public void collectBadRelationship(InputRelationship relationship, Object specificValue) {
        this.checkTolerance(1, new InputException(String.format("%s refering to missing node %s", relationship, specificValue)));
    }

    @Override
    public void collectDuplicateNode(Object id, long actualId, String group, String firstSource, String otherSource) {
        this.checkTolerance(2, new DuplicateInputIdException(id, group, firstSource, otherSource));
        if (this.leftOverDuplicateNodeIdsCursor == this.leftOverDuplicateNodeIds.length) {
            this.leftOverDuplicateNodeIds = Arrays.copyOf(this.leftOverDuplicateNodeIds, this.leftOverDuplicateNodeIds.length * 2);
        }
        this.leftOverDuplicateNodeIds[this.leftOverDuplicateNodeIdsCursor++] = actualId;
    }

    @Override
    public PrimitiveLongIterator leftOverDuplicateNodesIds() {
        return PrimitiveLongCollections.iterator((long[])Arrays.copyOf(this.leftOverDuplicateNodeIds, this.leftOverDuplicateNodeIdsCursor));
    }

    @Override
    public void close() {
        this.out.flush();
    }

    @Override
    public int badEntries() {
        return this.badEntries;
    }

    private boolean collects(int bit) {
        return (this.collect & bit) != 0;
    }

    private void checkTolerance(int bit, InputException exception) {
        boolean collect = this.collects(bit);
        if (collect) {
            this.out.println(exception.getMessage());
            ++this.badEntries;
        }
        if (!collect || this.badEntries > this.tolerance) {
            throw collect ? Exceptions.withMessage(exception, String.format("Too many bad entries %d, where last one was: ", this.badEntries) + exception.getMessage()) : exception;
        }
    }
}

