/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandRecordVisitor;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;

public class IndexDefineCommand
extends Command {
    private final AtomicInteger nextIndexNameId = new AtomicInteger();
    private final AtomicInteger nextKeyId = new AtomicInteger();
    private Map<String, Byte> indexNameIdRange;
    private Map<String, Byte> keyIdRange;
    private Map<Byte, String> idToIndexName;
    private Map<Byte, String> idToKey;

    public IndexDefineCommand() {
        this.setIndexNameIdRange(new HashMap<String, Byte>());
        this.setKeyIdRange(new HashMap<String, Byte>());
        this.idToIndexName = new HashMap<Byte, String>();
        this.idToKey = new HashMap<Byte, String>();
    }

    public void init(Map<String, Byte> indexNames, Map<String, Byte> keys) {
        this.setIndexNameIdRange(indexNames);
        this.setKeyIdRange(keys);
        this.idToIndexName = MapUtil.reverse(indexNames);
        this.idToKey = MapUtil.reverse(keys);
    }

    private static String getFromMap(Map<Byte, String> map, byte id) {
        if (id == -1) {
            return null;
        }
        String result = map.get(id);
        if (result == null) {
            throw new IllegalArgumentException("" + id);
        }
        return result;
    }

    public String getIndexName(byte id) {
        return IndexDefineCommand.getFromMap(this.idToIndexName, id);
    }

    public String getKey(byte id) {
        return IndexDefineCommand.getFromMap(this.idToKey, id);
    }

    public byte getOrAssignIndexNameId(String indexName) {
        return this.getOrAssignId(this.indexNameIdRange, this.idToIndexName, this.nextIndexNameId, indexName);
    }

    public byte getOrAssignKeyId(String key) {
        return this.getOrAssignId(this.keyIdRange, this.idToKey, this.nextKeyId, key);
    }

    private byte getOrAssignId(Map<String, Byte> stringToId, Map<Byte, String> idToString, AtomicInteger nextId, String string) {
        if (string == null) {
            return -1;
        }
        Byte id = stringToId.get(string);
        if (id != null) {
            return id;
        }
        int nextIdInt = nextId.incrementAndGet();
        if (nextIdInt > 63) {
            throw new IllegalStateException("Modifying more than 63 indexes in a single transaction is not supported");
        }
        id = (byte)nextIdInt;
        stringToId.put(string, id);
        idToString.put(id, string);
        return id;
    }

    @Override
    public int hashCode() {
        int result = this.nextIndexNameId != null ? this.nextIndexNameId.hashCode() : 0;
        result = 31 * result + (this.nextKeyId != null ? this.nextKeyId.hashCode() : 0);
        result = 31 * result + (this.getIndexNameIdRange() != null ? this.getIndexNameIdRange().hashCode() : 0);
        result = 31 * result + (this.getKeyIdRange() != null ? this.getKeyIdRange().hashCode() : 0);
        result = 31 * result + (this.idToIndexName != null ? this.idToIndexName.hashCode() : 0);
        result = 31 * result + (this.idToKey != null ? this.idToKey.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        IndexDefineCommand other = (IndexDefineCommand)obj;
        return this.getIndexNameIdRange().equals(other.getIndexNameIdRange()) && this.getKeyIdRange().equals(other.getKeyIdRange());
    }

    @Override
    public void accept(CommandRecordVisitor visitor) {
    }

    @Override
    public boolean handle(NeoCommandHandler visitor) throws IOException {
        return visitor.visitIndexDefineCommand(this);
    }

    public Map<String, Byte> getIndexNameIdRange() {
        return this.indexNameIdRange;
    }

    public void setIndexNameIdRange(Map<String, Byte> indexNameIdRange) {
        this.indexNameIdRange = indexNameIdRange;
    }

    public Map<String, Byte> getKeyIdRange() {
        return this.keyIdRange;
    }

    public void setKeyIdRange(Map<String, Byte> keyIdRange) {
        this.keyIdRange = keyIdRange;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[names:" + this.indexNameIdRange + ", keys:" + this.keyIdRange + "]";
    }
}

