/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.LegacyIndexHits;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.LegacyIndexNotFoundKernelException;
import org.neo4j.kernel.impl.api.legacyindex.AbstractIndexHits;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.locking.ResourceTypes;

public class LegacyIndexProxy<T extends PropertyContainer>
implements Index<T> {
    protected final String name;
    protected final Type type;
    protected final ThreadToStatementContextBridge statementContextBridge;
    private final Lookup lookup;

    public LegacyIndexProxy(String name, Type type, Lookup lookup, ThreadToStatementContextBridge statementContextBridge) {
        this.name = name;
        this.type = type;
        this.lookup = lookup;
        this.statementContextBridge = statementContextBridge;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getEntityType() {
        return this.type.getEntityType();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IndexHits<T> get(String key, Object value) {
        try (Statement statement = this.statementContextBridge.instance();){
            IndexHits<T> indexHits = this.wrapIndexHits(this.internalGet(key, value, statement));
            return indexHits;
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
    }

    private LegacyIndexHits internalGet(String key, Object value, Statement statement) throws LegacyIndexNotFoundKernelException {
        return this.type.get(statement.readOperations(), this.name, key, value);
    }

    protected IndexHits<T> wrapIndexHits(final LegacyIndexHits ids) {
        return new AbstractIndexHits<T>(){

            @Override
            public int size() {
                return ids.size();
            }

            @Override
            public float currentScore() {
                return ids.currentScore();
            }

            @Override
            protected T fetchNextOrNull() {
                LegacyIndexProxy.this.statementContextBridge.assertInUnterminatedTransaction();
                while (ids.hasNext()) {
                    long id = ids.next();
                    try {
                        return LegacyIndexProxy.this.entityOf(id);
                    }
                    catch (NotFoundException e) {
                        try {
                            Statement statement = LegacyIndexProxy.this.statementContextBridge.instance();
                            Throwable throwable = null;
                            try {
                                LegacyIndexProxy.this.internalRemove(statement, id);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (statement == null) continue;
                                if (throwable != null) {
                                    try {
                                        statement.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                    continue;
                                }
                                statement.close();
                            }
                        }
                        catch (EntityNotFoundException | InvalidTransactionTypeKernelException | LegacyIndexNotFoundKernelException ignore) {}
                    }
                }
                return null;
            }
        };
    }

    private T entityOf(long id) {
        return this.type.entity(id, this.lookup.getGraphDatabaseService());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IndexHits<T> query(String key, Object queryOrQueryObject) {
        try (Statement statement = this.statementContextBridge.instance();){
            IndexHits<T> indexHits = this.wrapIndexHits(this.type.query(statement.readOperations(), this.name, key, queryOrQueryObject));
            return indexHits;
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IndexHits<T> query(Object queryOrQueryObject) {
        try (Statement statement = this.statementContextBridge.instance();){
            IndexHits<T> indexHits = this.wrapIndexHits(this.type.query(statement.readOperations(), this.name, queryOrQueryObject));
            return indexHits;
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
    }

    @Override
    public boolean isWriteable() {
        return true;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.lookup.getGraphDatabaseService();
    }

    @Override
    public void add(T entity, String key, Object value) {
        try (Statement statement = this.statementContextBridge.instance();){
            this.internalAdd(entity, key, value, statement);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(String.format("%s %d not found", new Object[]{this.type, this.type.id((PropertyContainer)entity)}), e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
    }

    @Override
    public void remove(T entity, String key, Object value) {
        try (Statement statement = this.statementContextBridge.instance();){
            this.type.remove(statement.dataWriteOperations(), this.name, this.type.id((PropertyContainer)entity), key, value);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(entity + " doesn't exist");
        }
    }

    @Override
    public void remove(T entity, String key) {
        try (Statement statement = this.statementContextBridge.instance();){
            this.type.remove(statement.dataWriteOperations(), this.name, this.type.id((PropertyContainer)entity), key);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(entity + " doesn't exist");
        }
    }

    @Override
    public void remove(T entity) {
        try (Statement statement = this.statementContextBridge.instance();){
            this.internalRemove(statement, this.type.id((PropertyContainer)entity));
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(entity + " doesn't exist");
        }
    }

    private void internalRemove(Statement statement, long id) throws InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException, EntityNotFoundException {
        this.type.remove(statement.dataWriteOperations(), this.name, id);
    }

    @Override
    public void delete() {
        try (Statement statement = this.statementContextBridge.instance();){
            this.type.drop(statement.dataWriteOperations(), this.name);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T putIfAbsent(T entity, String key, Object value) {
        try (Statement statement = this.statementContextBridge.instance();){
            long existing = PrimitiveLongCollections.single((PrimitiveLongIterator)this.internalGet(key, value, statement), (long)-1L);
            if (existing != -1L) {
                T t = this.entityOf(existing);
                return t;
            }
            statement.readOperations().acquireExclusive(ResourceTypes.LEGACY_INDEX, ResourceTypes.legacyIndexResourceId(this.name, key));
            existing = PrimitiveLongCollections.single((PrimitiveLongIterator)this.internalGet(key, value, statement), (long)-1L);
            if (existing != -1L) {
                statement.readOperations().releaseExclusive(ResourceTypes.LEGACY_INDEX, ResourceTypes.legacyIndexResourceId(this.name, key));
                T t = this.entityOf(existing);
                return t;
            }
            this.internalAdd(entity, key, value, statement);
            T t = null;
            return t;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(String.format("%s %d not found", new Object[]{this.type, this.type.id((PropertyContainer)entity)}), e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new RuntimeException(e);
        }
    }

    private void internalAdd(T entity, String key, Object value, Statement statement) throws EntityNotFoundException, InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException {
        this.type.add(statement.dataWriteOperations(), this.name, this.type.id((PropertyContainer)entity), key, value);
    }

    public String toString() {
        return "Index[" + (Object)((Object)this.type) + ", " + this.name + "]";
    }

    public static interface Lookup {
        public GraphDatabaseService getGraphDatabaseService();
    }

    public static enum Type {
        NODE{

            Class<Node> getEntityType() {
                return Node.class;
            }

            Node entity(long id, GraphDatabaseService graphDatabaseService) {
                return graphDatabaseService.getNodeById(id);
            }

            @Override
            LegacyIndexHits get(ReadOperations operations, String name, String key, Object value) throws LegacyIndexNotFoundKernelException {
                return operations.nodeLegacyIndexGet(name, key, value);
            }

            @Override
            LegacyIndexHits query(ReadOperations operations, String name, String key, Object queryOrQueryObject) throws LegacyIndexNotFoundKernelException {
                return operations.nodeLegacyIndexQuery(name, key, queryOrQueryObject);
            }

            @Override
            LegacyIndexHits query(ReadOperations operations, String name, Object queryOrQueryObject) throws LegacyIndexNotFoundKernelException {
                return operations.nodeLegacyIndexQuery(name, queryOrQueryObject);
            }

            @Override
            void add(DataWriteOperations operations, String name, long id, String key, Object value) throws EntityNotFoundException, InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException {
                operations.nodeAddToLegacyIndex(name, id, key, value);
            }

            @Override
            void remove(DataWriteOperations operations, String name, long id, String key, Object value) throws InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException {
                operations.nodeRemoveFromLegacyIndex(name, id, key, value);
            }

            @Override
            void remove(DataWriteOperations operations, String name, long id, String key) throws InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException {
                operations.nodeRemoveFromLegacyIndex(name, id, key);
            }

            @Override
            void remove(DataWriteOperations operations, String name, long id) throws InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException {
                operations.nodeRemoveFromLegacyIndex(name, id);
            }

            @Override
            void drop(DataWriteOperations operations, String name) throws InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException {
                operations.nodeLegacyIndexDrop(name);
            }

            @Override
            long id(PropertyContainer entity) {
                return ((Node)entity).getId();
            }
        }
        ,
        RELATIONSHIP{

            Class<Relationship> getEntityType() {
                return Relationship.class;
            }

            Relationship entity(long id, GraphDatabaseService graphDatabaseService) {
                return graphDatabaseService.getRelationshipById(id);
            }

            @Override
            LegacyIndexHits get(ReadOperations operations, String name, String key, Object value) throws LegacyIndexNotFoundKernelException {
                return operations.relationshipLegacyIndexGet(name, key, value, -1L, -1L);
            }

            @Override
            LegacyIndexHits query(ReadOperations operations, String name, String key, Object queryOrQueryObject) throws LegacyIndexNotFoundKernelException {
                return operations.relationshipLegacyIndexQuery(name, key, queryOrQueryObject, -1L, -1L);
            }

            @Override
            LegacyIndexHits query(ReadOperations operations, String name, Object queryOrQueryObject) throws LegacyIndexNotFoundKernelException {
                return operations.relationshipLegacyIndexQuery(name, queryOrQueryObject, -1L, -1L);
            }

            @Override
            void add(DataWriteOperations operations, String name, long id, String key, Object value) throws EntityNotFoundException, InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException {
                operations.relationshipAddToLegacyIndex(name, id, key, value);
            }

            @Override
            void remove(DataWriteOperations operations, String name, long id, String key, Object value) throws InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException, EntityNotFoundException {
                operations.relationshipRemoveFromLegacyIndex(name, id, key, value);
            }

            @Override
            void remove(DataWriteOperations operations, String name, long id, String key) throws InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException, EntityNotFoundException {
                operations.relationshipRemoveFromLegacyIndex(name, id, key);
            }

            @Override
            void remove(DataWriteOperations operations, String name, long id) throws InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException, EntityNotFoundException {
                operations.relationshipRemoveFromLegacyIndex(name, id);
            }

            @Override
            void drop(DataWriteOperations operations, String name) throws InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException {
                operations.relationshipLegacyIndexDrop(name);
            }

            @Override
            long id(PropertyContainer entity) {
                return ((Relationship)entity).getId();
            }
        };


        abstract <T extends PropertyContainer> Class<T> getEntityType();

        abstract <T extends PropertyContainer> T entity(long var1, GraphDatabaseService var3);

        abstract LegacyIndexHits get(ReadOperations var1, String var2, String var3, Object var4) throws LegacyIndexNotFoundKernelException;

        abstract LegacyIndexHits query(ReadOperations var1, String var2, String var3, Object var4) throws LegacyIndexNotFoundKernelException;

        abstract LegacyIndexHits query(ReadOperations var1, String var2, Object var3) throws LegacyIndexNotFoundKernelException;

        abstract void add(DataWriteOperations var1, String var2, long var3, String var5, Object var6) throws EntityNotFoundException, InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException;

        abstract void remove(DataWriteOperations var1, String var2, long var3, String var5, Object var6) throws InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException, EntityNotFoundException;

        abstract void remove(DataWriteOperations var1, String var2, long var3, String var5) throws InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException, EntityNotFoundException;

        abstract void remove(DataWriteOperations var1, String var2, long var3) throws InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException, EntityNotFoundException;

        abstract void drop(DataWriteOperations var1, String var2) throws InvalidTransactionTypeKernelException, LegacyIndexNotFoundKernelException;

        abstract long id(PropertyContainer var1);
    }
}

