/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.InvalidTransactionTypeException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AddIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.schema.BaseConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.IndexCreatorImpl;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.PropertyUniqueConstraintDefinition;

public class SchemaImpl
implements Schema {
    private final ThreadToStatementContextBridge statementContextProvider;
    private final InternalSchemaActions actions;

    public SchemaImpl(ThreadToStatementContextBridge statementContextProvider) {
        this.statementContextProvider = statementContextProvider;
        this.actions = new GDBSchemaActions(statementContextProvider);
    }

    @Override
    public IndexCreator indexFor(Label label) {
        this.assertInUnterminatedTransaction();
        return new IndexCreatorImpl(this.actions, label);
    }

    @Override
    public Iterable<IndexDefinition> getIndexes(Label label) {
        this.assertInUnterminatedTransaction();
        try (Statement statement = this.statementContextProvider.instance();){
            ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
            int labelId = statement.readOperations().labelGetForName(label.name());
            if (labelId == -1) {
                List<IndexDefinition> list = Collections.emptyList();
                return list;
            }
            this.addDefinitions(definitions, statement.readOperations(), statement.readOperations().indexesGetForLabel(labelId), false);
            this.addDefinitions(definitions, statement.readOperations(), statement.readOperations().uniqueIndexesGetForLabel(labelId), true);
            ArrayList<IndexDefinition> arrayList = definitions;
            return arrayList;
        }
    }

    @Override
    public Iterable<IndexDefinition> getIndexes() {
        this.assertInUnterminatedTransaction();
        try (Statement statement = this.statementContextProvider.instance();){
            ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
            this.addDefinitions(definitions, statement.readOperations(), statement.readOperations().indexesGetAll(), false);
            this.addDefinitions(definitions, statement.readOperations(), statement.readOperations().uniqueIndexesGetAll(), true);
            ArrayList<IndexDefinition> arrayList = definitions;
            return arrayList;
        }
    }

    private void addDefinitions(List<IndexDefinition> definitions, final ReadOperations statement, Iterator<IndexDescriptor> indexes, final boolean constraintIndex) {
        IteratorUtil.addToCollection(Iterables.map(new Function<IndexDescriptor, IndexDefinition>(){

            public IndexDefinition apply(IndexDescriptor rule) {
                try {
                    Label label = DynamicLabel.label(statement.labelGetName(rule.getLabelId()));
                    String propertyKey = statement.propertyKeyGetName(rule.getPropertyKeyId());
                    return new IndexDefinitionImpl(SchemaImpl.this.actions, label, propertyKey, constraintIndex);
                }
                catch (LabelNotFoundKernelException | PropertyKeyIdNotFoundKernelException e) {
                    throw new RuntimeException(e);
                }
            }
        }, indexes), definitions);
    }

    @Override
    public void awaitIndexOnline(IndexDefinition index, long duration, TimeUnit unit) {
        this.assertInUnterminatedTransaction();
        long timeout = System.currentTimeMillis() + unit.toMillis(duration);
        do {
            Schema.IndexState state = this.getIndexState(index);
            switch (state) {
                case ONLINE: {
                    return;
                }
                case FAILED: {
                    throw new IllegalStateException("Index entered a FAILED state. Please see database logs.");
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (System.currentTimeMillis() < timeout);
        throw new IllegalStateException("Expected index to come online within a reasonable time.");
    }

    @Override
    public void awaitIndexesOnline(long duration, TimeUnit unit) {
        this.assertInUnterminatedTransaction();
        long millisLeft = TimeUnit.MILLISECONDS.convert(duration, unit);
        ArrayList<IndexDefinition> onlineIndexes = new ArrayList<IndexDefinition>();
        Iterator<IndexDefinition> iter = this.getIndexes().iterator();
        while (iter.hasNext()) {
            if (millisLeft < 0L) {
                throw new IllegalStateException("Expected all indexes to come online within a reasonable time.Indexes brought online: " + onlineIndexes + ". Indexes not guaranteed to be online: " + IteratorUtil.asCollection(iter));
            }
            IndexDefinition index = iter.next();
            long millisBefore = System.currentTimeMillis();
            this.awaitIndexOnline(index, millisLeft, TimeUnit.MILLISECONDS);
            millisLeft -= System.currentTimeMillis() - millisBefore;
            onlineIndexes.add(index);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Schema.IndexState getIndexState(IndexDefinition index) {
        this.assertInUnterminatedTransaction();
        String propertyKey = IteratorUtil.single(index.getPropertyKeys());
        try (Statement statement = this.statementContextProvider.instance();){
            int labelId = statement.readOperations().labelGetForName(index.getLabel().name());
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(propertyKey);
            if (labelId == -1) {
                throw new NotFoundException(String.format("Label %s not found", index.getLabel().name()));
            }
            if (propertyKeyId == -1) {
                throw new NotFoundException(String.format("Property key %s not found", propertyKey));
            }
            IndexDescriptor descriptor = statement.readOperations().indexesGetForLabelAndPropertyKey(labelId, propertyKeyId);
            InternalIndexState indexState = statement.readOperations().indexGetState(descriptor);
            switch (indexState) {
                case POPULATING: {
                    Schema.IndexState indexState2 = Schema.IndexState.POPULATING;
                    return indexState2;
                }
                case ONLINE: {
                    Schema.IndexState indexState3 = Schema.IndexState.ONLINE;
                    return indexState3;
                }
                case FAILED: {
                    Schema.IndexState indexState4 = Schema.IndexState.FAILED;
                    return indexState4;
                }
            }
            throw new IllegalArgumentException(String.format("Illegal index state %s", new Object[]{indexState}));
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), propertyKey));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getIndexFailure(IndexDefinition index) {
        this.assertInUnterminatedTransaction();
        String propertyKey = IteratorUtil.single(index.getPropertyKeys());
        try (Statement statement = this.statementContextProvider.instance();){
            int labelId = statement.readOperations().labelGetForName(index.getLabel().name());
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(propertyKey);
            if (labelId == -1) {
                throw new NotFoundException(String.format("Label %s not found", index.getLabel().name()));
            }
            if (propertyKeyId == -1) {
                throw new NotFoundException(String.format("Property key %s not found", propertyKey));
            }
            IndexDescriptor indexId = statement.readOperations().indexesGetForLabelAndPropertyKey(labelId, propertyKeyId);
            String string = statement.readOperations().indexGetFailure(indexId);
            return string;
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), propertyKey));
        }
    }

    @Override
    public ConstraintCreator constraintFor(Label label) {
        this.assertInUnterminatedTransaction();
        return new BaseConstraintCreator(this.actions, label);
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints() {
        this.assertInUnterminatedTransaction();
        try (Statement statement = this.statementContextProvider.instance();){
            Iterator<UniquenessConstraint> constraints = statement.readOperations().constraintsGetAll();
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(statement.readOperations(), constraints);
            return iterable;
        }
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints(Label label) {
        this.assertInUnterminatedTransaction();
        try (Statement statement = this.statementContextProvider.instance();){
            int labelId = statement.readOperations().labelGetForName(label.name());
            if (labelId == -1) {
                List<ConstraintDefinition> list = Collections.emptyList();
                return list;
            }
            Iterator<UniquenessConstraint> constraints = statement.readOperations().constraintsGetForLabel(labelId);
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(statement.readOperations(), constraints);
            return iterable;
        }
    }

    private Iterable<ConstraintDefinition> asConstraintDefinitions(final ReadOperations readOperations, Iterator<UniquenessConstraint> constraints) {
        Iterator<ConstraintDefinition> definitions = Iterables.map(new Function<UniquenessConstraint, ConstraintDefinition>(){

            public ConstraintDefinition apply(UniquenessConstraint constraint) {
                int labelId = constraint.label();
                try {
                    Label label = DynamicLabel.label(readOperations.labelGetName(labelId));
                    return new PropertyUniqueConstraintDefinition(SchemaImpl.this.actions, label, readOperations.propertyKeyGetName(constraint.propertyKeyId()));
                }
                catch (PropertyKeyIdNotFoundKernelException e) {
                    throw new ThisShouldNotHappenError("Mattias", "Couldn't find property name for " + constraint.propertyKeyId(), e);
                }
                catch (LabelNotFoundKernelException e) {
                    throw new ThisShouldNotHappenError("Stefan", "Couldn't find label name for label id " + labelId, e);
                }
            }
        }, constraints);
        return IteratorUtil.asCollection(definitions);
    }

    private void assertInUnterminatedTransaction() {
        this.statementContextProvider.assertInUnterminatedTransaction();
    }

    private static class GDBSchemaActions
    implements InternalSchemaActions {
        private final ThreadToStatementContextBridge ctxProvider;

        public GDBSchemaActions(ThreadToStatementContextBridge ctxProvider) {
            this.ctxProvider = ctxProvider;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public IndexDefinition createIndexDefinition(Label label, String propertyKey) {
            Throwable throwable = null;
            try (Statement statement = this.ctxProvider.instance();){
                int labelId = statement.schemaWriteOperations().labelGetOrCreateForName(label.name());
                int propertyKeyId = statement.schemaWriteOperations().propertyKeyGetOrCreateForName(propertyKey);
                statement.schemaWriteOperations().indexCreate(labelId, propertyKeyId);
                IndexDefinitionImpl indexDefinitionImpl = new IndexDefinitionImpl(this, label, propertyKey, false);
                return indexDefinitionImpl;
            }
            catch (AlreadyIndexedException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e);
                    catch (AlreadyConstrainedException e2) {
                        throw new ConstraintViolationException(e2.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e2);
                    }
                    catch (AddIndexFailureException e3) {
                        throw new ConstraintViolationException(e3.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e3);
                    }
                    catch (IllegalTokenNameException e4) {
                        throw new IllegalArgumentException(e4);
                    }
                    catch (TooManyLabelsException e5) {
                        throw new IllegalStateException(e5);
                    }
                    catch (InvalidTransactionTypeKernelException e6) {
                        throw new ConstraintViolationException(e6.getMessage(), e6);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        @Override
        public void dropIndexDefinitions(Label label, String propertyKey) {
            try (Statement statement = this.ctxProvider.instance();){
                int labelId = statement.readOperations().labelGetForName(label.name());
                int propertyKeyId = statement.readOperations().propertyKeyGetForName(propertyKey);
                if (labelId != -1 && propertyKeyId != -1) {
                    statement.schemaWriteOperations().indexDrop(statement.readOperations().indexesGetForLabelAndPropertyKey(labelId, propertyKeyId));
                }
            }
            catch (DropIndexFailureException | SchemaRuleNotFoundException e) {
                throw new ConstraintViolationException(String.format("Unable to drop index on label `%s` for property %s.", label.name(), propertyKey), e);
            }
            catch (InvalidTransactionTypeKernelException e) {
                throw new ConstraintViolationException(e.getMessage(), e);
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstraintDefinition createPropertyUniquenessConstraint(Label label, String propertyKey) {
            Throwable throwable = null;
            try (Statement statement = this.ctxProvider.instance();){
                int labelId = statement.schemaWriteOperations().labelGetOrCreateForName(label.name());
                int propertyKeyId = statement.schemaWriteOperations().propertyKeyGetOrCreateForName(propertyKey);
                statement.schemaWriteOperations().uniquenessConstraintCreate(labelId, propertyKeyId);
                PropertyUniqueConstraintDefinition propertyUniqueConstraintDefinition = new PropertyUniqueConstraintDefinition(this, label, propertyKey);
                return propertyUniqueConstraintDefinition;
            }
            catch (AlreadyConstrainedException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e);
                    catch (CreateConstraintFailureException e2) {
                        throw new ConstraintViolationException(e2.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e2);
                    }
                    catch (AlreadyIndexedException e3) {
                        throw new ConstraintViolationException(e3.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e3);
                    }
                    catch (IllegalTokenNameException e4) {
                        throw new IllegalArgumentException(e4);
                    }
                    catch (TooManyLabelsException e5) {
                        throw new IllegalStateException(e5);
                    }
                    catch (InvalidTransactionTypeKernelException e6) {
                        throw new InvalidTransactionTypeException(e6.getMessage(), e6);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        @Override
        public void dropPropertyUniquenessConstraint(Label label, String propertyKey) {
            try (Statement statement = this.ctxProvider.instance();){
                int labelId = statement.schemaWriteOperations().labelGetOrCreateForName(label.name());
                int propertyKeyId = statement.schemaWriteOperations().propertyKeyGetOrCreateForName(propertyKey);
                UniquenessConstraint constraint = new UniquenessConstraint(labelId, propertyKeyId);
                statement.schemaWriteOperations().constraintDrop(constraint);
            }
            catch (DropConstraintFailureException | IllegalTokenNameException | TooManyLabelsException e) {
                throw new ThisShouldNotHappenError("Mattias", "Unable to drop property unique constraint", e);
            }
            catch (InvalidTransactionTypeKernelException e) {
                throw new ConstraintViolationException(e.getMessage(), e);
            }
        }

        @Override
        public String getUserMessage(KernelException e) {
            try (Statement statement = this.ctxProvider.instance();){
                String string = e.getUserMessage(new StatementTokenNameLookup(statement.readOperations()));
                return string;
            }
        }

        @Override
        public void assertInUnterminatedTransaction() {
            this.ctxProvider.assertInUnterminatedTransaction();
        }
    }
}

