/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.util.JobScheduler;

public class IndexSamplingJobTracker {
    private final JobScheduler jobScheduler;
    private final int jobLimit;
    private final Set<IndexDescriptor> executingJobDescriptors;
    private final Lock lock = new ReentrantLock(true);
    private final Condition canSchedule = this.lock.newCondition();

    public IndexSamplingJobTracker(IndexSamplingConfig config, JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
        this.jobLimit = config.jobLimit();
        this.executingJobDescriptors = new HashSet<IndexDescriptor>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canExecuteMoreSamplingJobs() {
        this.lock.lock();
        try {
            boolean bl = this.executingJobDescriptors.size() < this.jobLimit;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSamplingJob(final IndexSamplingJob samplingJob) {
        this.lock.lock();
        try {
            IndexDescriptor descriptor = samplingJob.descriptor();
            if (this.executingJobDescriptors.contains(descriptor)) {
                return;
            }
            this.executingJobDescriptors.add(descriptor);
            this.jobScheduler.schedule(JobScheduler.Group.indexSampling, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        samplingJob.run();
                    }
                    finally {
                        IndexSamplingJobTracker.this.samplingJobCompleted(samplingJob);
                    }
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void samplingJobCompleted(IndexSamplingJob samplingJob) {
        this.lock.lock();
        try {
            this.executingJobDescriptors.remove(samplingJob.descriptor());
            this.canSchedule.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilCanExecuteMoreSamplingJobs() {
        this.lock.lock();
        try {
            while (!this.canExecuteMoreSamplingJobs()) {
                this.canSchedule.awaitUninterruptibly();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

