/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.collection.pool.Pool;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.api.txstate.TxStateVisitor;
import org.neo4j.kernel.impl.api.CachingLegacyIndexTransactionState;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.DegreeVisitor;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RecordStateForCacheAccessor;
import org.neo4j.kernel.impl.api.RelationshipDataExtractor;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.store.PersistenceCache;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.kernel.impl.util.collection.ArrayCollection;

public class KernelTransactionImplementation
implements KernelTransaction,
TxStateHolder {
    private final SchemaWriteGuard schemaWriteGuard;
    private final IndexingService indexService;
    private final TransactionHooks hooks;
    private final LabelScanStore labelScanStore;
    private final SchemaStorage schemaStorage;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final SchemaIndexProviderMap providerMap;
    private final UpdateableSchemaState schemaState;
    private final StatementOperationParts operations;
    private final Pool<KernelTransactionImplementation> pool;
    private final TransactionRecordState recordState;
    private final CountsRecordState counts = new CountsRecordState();
    private final RecordStateForCacheAccessor recordStateForCache;
    private final TransactionHeaderInformationFactory headerInformationFactory;
    private final TransactionCommitProcess commitProcess;
    private final TransactionMonitor transactionMonitor;
    private final PersistenceCache persistenceCache;
    private final StoreReadLayer storeLayer;
    private final Clock clock;
    private final TransactionToRecordStateVisitor txStateToRecordStateVisitor = new TransactionToRecordStateVisitor();
    private final Collection<Command> extractedCommands = new ArrayCollection<Command>(32);
    private TransactionState txState;
    private LegacyIndexTransactionState legacyIndexTransactionState;
    private TransactionType transactionType = TransactionType.ANY;
    private TransactionHooks.TransactionHooksState hooksState;
    private Locks.Client locks;
    private boolean closing;
    private boolean closed;
    private boolean failure;
    private boolean success;
    private volatile boolean terminated;
    private long startTimeMillis;
    private long lastTransactionIdWhenStarted;
    private KernelStatement currentStatement;
    private final TransactionTracer tracer;
    private TransactionEvent transactionEvent;

    public KernelTransactionImplementation(StatementOperationParts operations, SchemaWriteGuard schemaWriteGuard, LabelScanStore labelScanStore, IndexingService indexService, UpdateableSchemaState schemaState, TransactionRecordState recordState, RecordStateForCacheAccessor recordStateForCache, SchemaIndexProviderMap providerMap, NeoStore neoStore, Locks.Client locks, TransactionHooks hooks, ConstraintIndexCreator constraintIndexCreator, TransactionHeaderInformationFactory headerInformationFactory, TransactionCommitProcess commitProcess, TransactionMonitor transactionMonitor, PersistenceCache persistenceCache, StoreReadLayer storeLayer, LegacyIndexTransactionState legacyIndexTransactionState, Pool<KernelTransactionImplementation> pool, Clock clock, TransactionTracer tracer) {
        this.operations = operations;
        this.schemaWriteGuard = schemaWriteGuard;
        this.labelScanStore = labelScanStore;
        this.indexService = indexService;
        this.recordState = recordState;
        this.recordStateForCache = recordStateForCache;
        this.providerMap = providerMap;
        this.schemaState = schemaState;
        this.hooks = hooks;
        this.locks = locks;
        this.constraintIndexCreator = constraintIndexCreator;
        this.headerInformationFactory = headerInformationFactory;
        this.commitProcess = commitProcess;
        this.transactionMonitor = transactionMonitor;
        this.persistenceCache = persistenceCache;
        this.storeLayer = storeLayer;
        this.legacyIndexTransactionState = new CachingLegacyIndexTransactionState(legacyIndexTransactionState);
        this.pool = pool;
        this.clock = clock;
        this.schemaStorage = new SchemaStorage(neoStore.getSchemaStore());
        this.tracer = tracer;
    }

    public KernelTransactionImplementation initialize(long lastCommittedTx) {
        assert (this.locks != null) : "This transaction has been disposed off, it should not be used.";
        this.success = false;
        this.failure = false;
        this.closed = false;
        this.closing = false;
        this.terminated = false;
        this.transactionType = TransactionType.ANY;
        this.hooksState = null;
        this.txState = null;
        this.legacyIndexTransactionState.initialize();
        this.recordState.initialize(lastCommittedTx);
        this.counts.initialize();
        this.startTimeMillis = this.clock.currentTimeMillis();
        this.lastTransactionIdWhenStarted = lastCommittedTx;
        this.transactionEvent = this.tracer.beginTransaction();
        assert (this.transactionEvent != null) : "transactionEvent was null!";
        return this;
    }

    @Override
    public void success() {
        this.success = true;
    }

    @Override
    public void failure() {
        this.failure = true;
    }

    @Override
    public boolean shouldBeTerminated() {
        return this.terminated;
    }

    @Override
    public void markForTermination() {
        if (!this.terminated) {
            this.failure = true;
            this.terminated = true;
            this.transactionMonitor.transactionTerminated();
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed && !this.closing;
    }

    @Override
    public KernelStatement acquireStatement() {
        this.assertTransactionOpen();
        if (this.currentStatement == null) {
            this.currentStatement = new KernelStatement(this, new IndexReaderFactory.Caching(this.indexService), this.labelScanStore, this, this.locks, this.operations);
        }
        this.currentStatement.acquire();
        return this.currentStatement;
    }

    public void releaseStatement(Statement statement) {
        assert (this.currentStatement == statement);
        this.currentStatement = null;
    }

    public void upgradeToDataTransaction() throws InvalidTransactionTypeKernelException {
        this.transactionType = this.transactionType.upgradeToDataTransaction();
    }

    public void upgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
        this.doUpgradeToSchemaTransaction();
        this.transactionType = this.transactionType.upgradeToSchemaTransaction();
    }

    public void doUpgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
        this.schemaWriteGuard.assertSchemaWritesAllowed();
    }

    private void dropCreatedConstraintIndexes() throws TransactionFailureException {
        if (this.hasTxStateWithChanges()) {
            for (IndexDescriptor createdConstraintIndex : this.txState().constraintIndexesCreatedInTx()) {
                try {
                    this.constraintIndexCreator.dropUniquenessConstraintIndex(createdConstraintIndex);
                }
                catch (DropIndexFailureException e) {
                    throw new IllegalStateException("Constraint index that was created in a transaction should be possible to drop during rollback of that transaction.", e);
                }
            }
        }
    }

    @Override
    public TransactionState txState() {
        if (this.txState == null) {
            this.txState = new TxState();
        }
        return this.txState;
    }

    @Override
    public LegacyIndexTransactionState legacyIndexTxState() {
        return this.legacyIndexTransactionState;
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.txState != null && this.txState.hasChanges();
    }

    private void closeTransaction() {
        this.assertTransactionOpen();
        this.closed = true;
        if (this.currentStatement != null) {
            this.currentStatement.forceClose();
            this.currentStatement = null;
        }
    }

    private void closeCurrentStatementIfAny() {
        if (this.currentStatement != null) {
            this.currentStatement.forceClose();
            this.currentStatement = null;
        }
    }

    private void assertTransactionNotClosing() {
        if (this.closing) {
            throw new IllegalStateException("This transaction is already being closed.");
        }
    }

    private void prepareRecordChangesFromTransactionState() {
        if (this.hasTxStateWithChanges()) {
            this.txState().accept(this.txStateToRecordStateVisitor);
            this.txStateToRecordStateVisitor.done();
        }
    }

    private void assertTransactionOpen() {
        if (this.closed) {
            throw new IllegalStateException("This transaction has already been completed.");
        }
    }

    private boolean hasChanges() {
        return this.hasTxStateWithChanges() || this.recordState.hasChanges() || this.legacyIndexTransactionState.hasChanges() || this.counts.hasChanges();
    }

    public TransactionRecordState getTransactionRecordState() {
        return this.recordState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws TransactionFailureException {
        block10: {
            this.assertTransactionOpen();
            this.assertTransactionNotClosing();
            this.closeCurrentStatementIfAny();
            this.closing = true;
            try {
                if (this.failure || !this.success) {
                    this.rollback();
                    if (this.success) {
                        throw new TransactionFailureException((Status)Status.Transaction.MarkedAsFailed, "Transaction rolled back even if marked as successful", new Object[0]);
                    }
                    break block10;
                }
                this.commit();
            }
            catch (Throwable throwable) {
                try {
                    this.closed = true;
                    this.closing = false;
                    this.transactionEvent.setSuccess(this.success);
                    this.transactionEvent.setFailure(this.failure);
                    this.transactionEvent.setTransactionType(this.transactionType.name());
                    this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
                    this.transactionEvent.close();
                    this.transactionEvent = null;
                }
                finally {
                    this.release();
                }
                throw throwable;
            }
        }
        try {
            this.closed = true;
            this.closing = false;
            this.transactionEvent.setSuccess(this.success);
            this.transactionEvent.setFailure(this.failure);
            this.transactionEvent.setTransactionType(this.transactionType.name());
            this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
            this.transactionEvent.close();
            this.transactionEvent = null;
        }
        finally {
            this.release();
        }
    }

    protected void dispose() {
        if (this.locks != null) {
            this.locks.close();
        }
        this.locks = null;
        this.transactionType = null;
        this.hooksState = null;
        this.txState = null;
        this.legacyIndexTransactionState = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit() throws TransactionFailureException {
        boolean success = false;
        try (CommitEvent commitEvent = this.transactionEvent.beginCommitEvent();){
            this.hooksState = this.hooks.beforeCommit(this.txState, this, this.storeLayer);
            if (this.hooksState != null && this.hooksState.failed()) {
                throw new TransactionFailureException((Status)Status.Transaction.HookFailed, (Throwable)this.hooksState.failure(), "", new Object[0]);
            }
            this.prepareRecordChangesFromTransactionState();
            if (this.hasChanges()) {
                try (LockGroup lockGroup = new LockGroup();){
                    this.extractedCommands.clear();
                    this.recordState.extractCommands(this.extractedCommands);
                    this.legacyIndexTransactionState.extractCommands(this.extractedCommands);
                    this.counts.extractCommands(this.extractedCommands);
                    if (!this.extractedCommands.isEmpty()) {
                        PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation(this.extractedCommands);
                        TransactionHeaderInformation headerInformation = this.headerInformationFactory.create();
                        transactionRepresentation.setHeader(headerInformation.getAdditionalHeader(), headerInformation.getMasterId(), headerInformation.getAuthorId(), this.startTimeMillis, this.lastTransactionIdWhenStarted, this.clock.currentTimeMillis(), this.locks.getLockSessionId());
                        this.commitProcess.commit(transactionRepresentation, lockGroup, commitEvent);
                    }
                    if (this.hasTxStateWithChanges()) {
                        this.persistenceCache.apply(this.txState, this.recordStateForCache);
                    }
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                this.rollback();
            } else {
                this.afterCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollback() throws TransactionFailureException {
        try {
            try {
                this.dropCreatedConstraintIndexes();
            }
            catch (IllegalStateException | SecurityException e) {
                throw new TransactionFailureException((Status)Status.Transaction.CouldNotRollback, (Throwable)e, "Could not drop created constraint indexes", new Object[0]);
            }
            if (this.txState != null) {
                this.txState.accept(new TxStateVisitor.Adapter(){

                    @Override
                    public void visitCreatedNode(long id) {
                        KernelTransactionImplementation.this.storeLayer.releaseNode(id);
                    }

                    @Override
                    public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                        KernelTransactionImplementation.this.storeLayer.releaseRelationship(id);
                    }
                });
            }
            if (this.hasTxStateWithChanges()) {
                this.persistenceCache.invalidate(this.txState);
            }
        }
        finally {
            this.afterRollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterCommit() {
        try {
            this.closeTransaction();
            this.hooks.afterCommit(this.txState, this, this.hooksState);
        }
        finally {
            this.transactionMonitor.transactionFinished(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterRollback() {
        try {
            this.closeTransaction();
            this.hooks.afterRollback(this.txState, this, this.hooksState);
        }
        finally {
            this.transactionMonitor.transactionFinished(false);
        }
    }

    private void release() {
        this.locks.releaseAll();
        this.pool.release((Object)this);
    }

    private void updateRelationshipsCountsFromDegrees(int type, int label, int outgoing, int incoming) {
        this.counts.incrementRelationshipCount(label, -1, -1, outgoing);
        this.counts.incrementRelationshipCount(-1, -1, label, incoming);
        this.counts.incrementRelationshipCount(label, type, -1, outgoing);
        this.counts.incrementRelationshipCount(-1, type, label, incoming);
    }

    private void updateRelationshipCount(long startNode, int type, long endNode, int delta) throws EntityNotFoundException {
        this.updateRelationshipsCountsFromDegrees(type, -1, delta, 0);
        PrimitiveIntIterator startLabels = this.labelsOf(startNode);
        while (startLabels.hasNext()) {
            this.updateRelationshipsCountsFromDegrees(type, startLabels.next(), delta, 0);
        }
        PrimitiveIntIterator endLabels = this.labelsOf(endNode);
        while (endLabels.hasNext()) {
            this.updateRelationshipsCountsFromDegrees(type, endLabels.next(), 0, delta);
        }
    }

    private PrimitiveIntIterator labelsOf(long nodeId) throws EntityNotFoundException {
        return StateHandlingStatementOperations.nodeGetLabels(this.storeLayer, this.txState, nodeId);
    }

    private class TransactionToRecordStateVisitor
    extends TxStateVisitor.Adapter {
        private final RelationshipDataExtractor edge = new RelationshipDataExtractor();
        private boolean clearState;

        private TransactionToRecordStateVisitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void done() {
            try {
                if (this.clearState) {
                    KernelTransactionImplementation.this.schemaState.clear();
                }
            }
            finally {
                this.clearState = false;
            }
        }

        @Override
        public void visitCreatedNode(long id) {
            KernelTransactionImplementation.this.recordState.nodeCreate(id);
            KernelTransactionImplementation.this.counts.incrementNodeCount(-1, 1L);
        }

        @Override
        public void visitDeletedNode(long id) {
            try {
                KernelTransactionImplementation.this.counts.incrementNodeCount(-1, -1L);
                PrimitiveIntIterator labels = KernelTransactionImplementation.this.storeLayer.nodeGetLabels(id);
                if (labels.hasNext()) {
                    int[] removed;
                    for (int label : removed = PrimitiveIntCollections.asArray((PrimitiveIntIterator)labels)) {
                        KernelTransactionImplementation.this.counts.incrementNodeCount(label, -1L);
                    }
                    KernelTransactionImplementation.this.storeLayer.nodeVisitDegrees(id, new DegreeVisitor(){

                        @Override
                        public void visitDegree(int type, int outgoing, int incoming) {
                            for (int label : removed) {
                                KernelTransactionImplementation.this.updateRelationshipsCountsFromDegrees(type, label, -outgoing, -incoming);
                            }
                        }
                    });
                }
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
            KernelTransactionImplementation.this.recordState.nodeDelete(id);
        }

        @Override
        public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
            try {
                KernelTransactionImplementation.this.updateRelationshipCount(startNode, type, endNode, 1);
            }
            catch (EntityNotFoundException e) {
                throw new IllegalStateException("Nodes with added relationships should exist.", e);
            }
            KernelTransactionImplementation.this.recordState.relCreate(id, type, startNode, endNode);
        }

        @Override
        public void visitDeletedRelationship(long id) {
            try {
                KernelTransactionImplementation.this.storeLayer.relationshipVisit(id, this.edge);
                KernelTransactionImplementation.this.updateRelationshipCount(this.edge.startNode(), this.edge.type(), this.edge.endNode(), -1);
            }
            catch (EntityNotFoundException e) {
                throw new IllegalStateException("Relationship being deleted should exist along with its nodes.", e);
            }
            KernelTransactionImplementation.this.recordState.relDelete(id);
        }

        @Override
        public void visitNodePropertyChanges(long id, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
            DefinedProperty prop;
            while (removed.hasNext()) {
                KernelTransactionImplementation.this.recordState.nodeRemoveProperty(id, removed.next());
            }
            while (changed.hasNext()) {
                prop = changed.next();
                KernelTransactionImplementation.this.recordState.nodeChangeProperty(id, prop.propertyKeyId(), prop.value());
            }
            while (added.hasNext()) {
                prop = added.next();
                KernelTransactionImplementation.this.recordState.nodeAddProperty(id, prop.propertyKeyId(), prop.value());
            }
        }

        @Override
        public void visitRelPropertyChanges(long id, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
            DefinedProperty prop;
            while (removed.hasNext()) {
                KernelTransactionImplementation.this.recordState.relRemoveProperty(id, removed.next());
            }
            while (changed.hasNext()) {
                prop = changed.next();
                KernelTransactionImplementation.this.recordState.relChangeProperty(id, prop.propertyKeyId(), prop.value());
            }
            while (added.hasNext()) {
                prop = added.next();
                KernelTransactionImplementation.this.recordState.relAddProperty(id, prop.propertyKeyId(), prop.value());
            }
        }

        @Override
        public void visitGraphPropertyChanges(Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
            DefinedProperty prop;
            while (removed.hasNext()) {
                KernelTransactionImplementation.this.recordState.graphRemoveProperty(removed.next());
            }
            while (changed.hasNext()) {
                prop = changed.next();
                KernelTransactionImplementation.this.recordState.graphChangeProperty(prop.propertyKeyId(), prop.value());
            }
            while (added.hasNext()) {
                prop = added.next();
                KernelTransactionImplementation.this.recordState.graphAddProperty(prop.propertyKeyId(), prop.value());
            }
        }

        @Override
        public void visitNodeLabelChanges(long id, final Set<Integer> added, final Set<Integer> removed) {
            if (!added.isEmpty() || !removed.isEmpty()) {
                for (Integer label : added) {
                    KernelTransactionImplementation.this.counts.incrementNodeCount(label, 1L);
                }
                for (Integer label : removed) {
                    KernelTransactionImplementation.this.counts.incrementNodeCount(label, -1L);
                }
                KernelTransactionImplementation.this.storeLayer.nodeVisitDegrees(id, new DegreeVisitor(){

                    @Override
                    public void visitDegree(int type, int outgoing, int incoming) {
                        for (Integer label : added) {
                            KernelTransactionImplementation.this.updateRelationshipsCountsFromDegrees(type, label, outgoing, incoming);
                        }
                        for (Integer label : removed) {
                            KernelTransactionImplementation.this.updateRelationshipsCountsFromDegrees(type, label, -outgoing, -incoming);
                        }
                    }
                });
            }
            for (Integer label : removed) {
                KernelTransactionImplementation.this.recordState.removeLabelFromNode(label, id);
            }
            for (Integer label : added) {
                KernelTransactionImplementation.this.recordState.addLabelToNode(label, id);
            }
        }

        @Override
        public void visitAddedIndex(IndexDescriptor element, boolean isConstraintIndex) {
            SchemaIndexProvider.Descriptor providerDescriptor = KernelTransactionImplementation.this.providerMap.getDefaultProvider().getProviderDescriptor();
            IndexRule rule = isConstraintIndex ? IndexRule.constraintIndexRule(KernelTransactionImplementation.this.schemaStorage.newRuleId(), element.getLabelId(), element.getPropertyKeyId(), providerDescriptor, null) : IndexRule.indexRule(KernelTransactionImplementation.this.schemaStorage.newRuleId(), element.getLabelId(), element.getPropertyKeyId(), providerDescriptor);
            KernelTransactionImplementation.this.recordState.createSchemaRule(rule);
        }

        @Override
        public void visitRemovedIndex(IndexDescriptor element, boolean isConstraintIndex) {
            SchemaStorage.IndexRuleKind kind = isConstraintIndex ? SchemaStorage.IndexRuleKind.CONSTRAINT : SchemaStorage.IndexRuleKind.INDEX;
            IndexRule rule = KernelTransactionImplementation.this.schemaStorage.indexRule(element.getLabelId(), element.getPropertyKeyId(), kind);
            KernelTransactionImplementation.this.recordState.dropSchemaRule(rule);
        }

        @Override
        public void visitAddedConstraint(UniquenessConstraint element) {
            this.clearState = true;
            long constraintId = KernelTransactionImplementation.this.schemaStorage.newRuleId();
            IndexRule indexRule = KernelTransactionImplementation.this.schemaStorage.indexRule(element.label(), element.propertyKeyId(), SchemaStorage.IndexRuleKind.CONSTRAINT);
            KernelTransactionImplementation.this.recordState.createSchemaRule(UniquenessConstraintRule.uniquenessConstraintRule(constraintId, element.label(), element.propertyKeyId(), indexRule.getId()));
            KernelTransactionImplementation.this.recordState.setConstraintIndexOwner(indexRule, constraintId);
        }

        @Override
        public void visitRemovedConstraint(UniquenessConstraint element) {
            try {
                this.clearState = true;
                UniquenessConstraintRule rule = KernelTransactionImplementation.this.schemaStorage.uniquenessConstraint(element.label(), element.propertyKeyId());
                KernelTransactionImplementation.this.recordState.dropSchemaRule(rule);
            }
            catch (SchemaRuleNotFoundException e) {
                throw new ThisShouldNotHappenError("Tobias Lindaaker", "Constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
            }
            this.visitRemovedIndex(new IndexDescriptor(element.label(), element.propertyKeyId()), true);
        }

        @Override
        public void visitCreatedLabelToken(String name, int id) {
            KernelTransactionImplementation.this.recordState.createLabelToken(name, id);
        }

        @Override
        public void visitCreatedPropertyKeyToken(String name, int id) {
            KernelTransactionImplementation.this.recordState.createPropertyKeyToken(name, id);
        }

        @Override
        public void visitCreatedRelationshipTypeToken(String name, int id) {
            KernelTransactionImplementation.this.recordState.createRelationshipTypeToken(name, id);
        }

        @Override
        public void visitCreatedNodeLegacyIndex(String name, Map<String, String> config) {
            KernelTransactionImplementation.this.legacyIndexTransactionState.createIndex(IndexEntityType.Node, name, config);
        }

        @Override
        public void visitCreatedRelationshipLegacyIndex(String name, Map<String, String> config) {
            KernelTransactionImplementation.this.legacyIndexTransactionState.createIndex(IndexEntityType.Relationship, name, config);
        }
    }

    private static enum TransactionType {
        ANY,
        DATA{

            @Override
            TransactionType upgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform schema updates in a transaction that has performed data updates.");
            }
        }
        ,
        SCHEMA{

            @Override
            TransactionType upgradeToDataTransaction() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform data updates in a transaction that has performed schema updates.");
            }
        };


        TransactionType upgradeToDataTransaction() throws InvalidTransactionTypeKernelException {
            return DATA;
        }

        TransactionType upgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
            return SCHEMA;
        }
    }
}

