/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Iterator;

public interface DependencyResolver {
    public <T> T resolveDependency(Class<T> var1) throws IllegalArgumentException;

    public <T> T resolveDependency(Class<T> var1, SelectionStrategy var2) throws IllegalArgumentException;

    public static abstract class Adapter
    implements DependencyResolver {
        private static final SelectionStrategy FIRST = new SelectionStrategy(){

            @Override
            public <T> T select(Class<T> type, Iterable<T> candidates) throws IllegalArgumentException {
                Iterator<T> iterator = candidates.iterator();
                if (!iterator.hasNext()) {
                    throw new IllegalArgumentException("Could not resolve dependency of type:" + type.getName());
                }
                return iterator.next();
            }
        };

        @Override
        public <T> T resolveDependency(Class<T> type) throws IllegalArgumentException {
            return this.resolveDependency(type, FIRST);
        }
    }

    public static interface SelectionStrategy {
        public <T> T select(Class<T> var1, Iterable<T> var2) throws IllegalArgumentException;
    }
}

