/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.collection.pool.Pool;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.util.SimplePool;
import org.neo4j.unsafe.impl.batchimport.Parallelizable;
import org.neo4j.unsafe.impl.batchimport.WriterFactories;
import org.neo4j.unsafe.impl.batchimport.store.io.Monitor;
import sun.misc.Cleaner;

public class BatchingPageCache
implements PageCache {
    public static final WriterFactory SYNCHRONOUS = new WriterFactories.SingleThreadedWriterFactory(){

        @Override
        public Writer create(final StoreChannel channel, final Monitor monitor) {
            return new Writer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(ByteBuffer data, long position, Pool<ByteBuffer> poolToReleaseBufferIn) throws IOException {
                    try {
                        int written = channel.write(data, position);
                        monitor.dataWritten(written);
                    }
                    finally {
                        poolToReleaseBufferIn.release((Object)data);
                    }
                }
            };
        }

        @Override
        public void awaitEverythingWritten() {
        }

        @Override
        public void shutdown() {
        }

        public String toString() {
            return "SYNCHRONOUS";
        }
    };
    private final int pageSize;
    private final int bigFileMultiplier;
    private final FileSystemAbstraction fs;
    private final Map<File, BatchingPagedFile> pagedFiles = new HashMap<File, BatchingPagedFile>();
    private final WriterFactory writerFactory;
    private final Monitor monitor;
    private static final int READ_WRITE_PF_FLAGS = 3;
    private static final ByteBuffer ZEROS = ByteBuffer.allocateDirect(4096);

    public BatchingPageCache(FileSystemAbstraction fs, int pageSize, int bigFileMultiplier, WriterFactory writerFactory, Monitor monitor) {
        this.fs = fs;
        this.pageSize = pageSize;
        this.bigFileMultiplier = bigFileMultiplier;
        this.writerFactory = writerFactory;
        this.monitor = monitor;
    }

    public PagedFile map(final File file, int pageSize) throws IOException {
        StoreChannel channel = this.fs.open(file, "rw");
        Writer writer = file.getName().contains(".counts.db") ? SYNCHRONOUS.create(channel, this.monitor) : this.writerFactory.create(channel, this.monitor);
        BatchingPagedFile pageFile = new BatchingPagedFile(channel, writer, this.individualizedPageSize(file, pageSize), new Closeable(){

            @Override
            public void close() throws IOException {
                BatchingPagedFile pageFile = (BatchingPagedFile)BatchingPageCache.this.pagedFiles.remove(file);
                if (pageFile == null) {
                    throw new IllegalArgumentException(file.toString());
                }
            }
        });
        this.pagedFiles.put(file, pageFile);
        return pageFile;
    }

    private int individualizedPageSize(File file, int pageSize) {
        return file.getName().endsWith(".relationshipstore.db") ? this.maxPercentageOfHeapThough(pageSize * this.bigFileMultiplier, 10.0f) : pageSize;
    }

    private int maxPercentageOfHeapThough(int size, float maxPercentageOfHeap) {
        return Math.min(size, (int)((float)Runtime.getRuntime().maxMemory() * (maxPercentageOfHeap / 100.0f)));
    }

    public void flushAndForce() throws IOException {
        for (PagedFile pagedFile : this.pagedFiles.values()) {
            pagedFile.flushAndForce();
        }
    }

    public void close() throws IOException {
        for (BatchingPagedFile pagedFile : this.pagedFiles.values()) {
            pagedFile.close();
        }
        this.pagedFiles.clear();
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int maxCachedPages() {
        return 1;
    }

    private static void zeroBuffer(ByteBuffer buffer) {
        ByteBuffer zeros = ZEROS.duplicate();
        buffer.clear();
        while (buffer.hasRemaining()) {
            int chunkSize = Math.min(buffer.remaining(), zeros.capacity());
            zeros.clear();
            zeros.limit(chunkSize);
            buffer.put(zeros);
        }
    }

    private static class WriteCursor
    extends BatchingPageCursor {
        WriteCursor(StoreChannel channel, Writer writer, int pageSize) throws IOException {
            super(channel, writer, pageSize, 2);
        }

        @Override
        protected void placeBufferAt(ByteBuffer buffer, long pageId) throws IOException {
            if (pageId == 0L) {
                this.readFromChannelIntoBuffer(pageId);
            } else {
                BatchingPageCache.zeroBuffer(buffer);
            }
        }

        @Override
        protected void doFlush() throws IOException {
            if (this.changed) {
                this.writer.write(this.prepared(this.currentBuffer), this.currentPageId * (long)this.pageSize, this.bufferPool);
                this.currentBuffer = (ByteBuffer)this.bufferPool.acquire();
                this.changed = false;
            }
        }
    }

    private static class ReadCursor
    extends BatchingPageCursor {
        ReadCursor(StoreChannel channel, Writer writer, int pageSize) throws IOException {
            super(channel, writer, pageSize, 1);
        }

        @Override
        protected void placeBufferAt(ByteBuffer buffer, long pageId) throws IOException {
            this.readFromChannelIntoBuffer(pageId);
        }

        @Override
        protected void doFlush() throws IOException {
            assert (!this.changed);
        }
    }

    private static abstract class BatchingPageCursor
    implements PageCursor {
        protected ByteBuffer currentBuffer;
        private final ByteBuffer[] buffers;
        protected final SimplePool<ByteBuffer> bufferPool;
        private final StoreChannel channel;
        protected final Writer writer;
        protected long currentPageId = -1L;
        protected final int pageSize;
        private boolean pinned;
        private long highestKnownPageId;
        protected boolean changed;

        BatchingPageCursor(StoreChannel channel, Writer writer, int pageSize, int bufferCount) throws IOException {
            this.channel = channel;
            this.writer = writer;
            this.pageSize = pageSize;
            this.buffers = new ByteBuffer[bufferCount];
            for (int i = 0; i < this.buffers.length; ++i) {
                try {
                    this.buffers[i] = ByteBuffer.allocateDirect(pageSize);
                    continue;
                }
                catch (OutOfMemoryError e) {
                    this.buffers[i] = ByteBuffer.allocate(pageSize);
                }
            }
            this.bufferPool = new SimplePool<ByteBuffer>(this.buffers);
            this.currentBuffer = this.bufferPool.acquire();
            this.highestKnownPageId = channel.size() / (long)pageSize;
        }

        private void free() {
            for (ByteBuffer buffer : this.buffers) {
                this.optimisticallyAndPreemtivelyFree(buffer);
            }
        }

        private void optimisticallyAndPreemtivelyFree(ByteBuffer byteBuffer) {
            if (byteBuffer.isDirect()) {
                try {
                    Method method = byteBuffer.getClass().getMethod("cleaner", new Class[0]);
                    method.setAccessible(true);
                    Cleaner cleaner = (Cleaner)method.invoke((Object)byteBuffer, new Object[0]);
                    cleaner.clean();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public byte getByte() {
            return this.currentBuffer.get();
        }

        public byte getByte(int offset) {
            return this.currentBuffer.get(offset);
        }

        public void putByte(byte value) {
            this.currentBuffer.put(value);
            this.changed = true;
        }

        public void putByte(int offset, byte value) {
            this.currentBuffer.put(offset, value);
        }

        public long getLong() {
            return this.currentBuffer.getLong();
        }

        public long getLong(int offset) {
            return this.currentBuffer.getLong(offset);
        }

        public void putLong(long value) {
            this.currentBuffer.putLong(value);
            this.changed = true;
        }

        public void putLong(int offset, long value) {
            this.currentBuffer.putLong(offset, value);
        }

        public int getInt() {
            return this.currentBuffer.getInt();
        }

        public int getInt(int offset) {
            return this.currentBuffer.getInt(offset);
        }

        public void putInt(int value) {
            this.currentBuffer.putInt(value);
            this.changed = true;
        }

        public void putInt(int offset, int value) {
            this.currentBuffer.putInt(offset, value);
        }

        public long getUnsignedInt() {
            return (long)this.getInt() & 0xFFFFFFFFL;
        }

        public long getUnsignedInt(int offset) {
            return (long)this.getInt(offset) & 0xFFFFFFFFL;
        }

        public void getBytes(byte[] data) {
            this.currentBuffer.get(data);
        }

        public void putBytes(byte[] data) {
            this.currentBuffer.put(data);
            this.changed = true;
        }

        public short getShort() {
            return this.currentBuffer.getShort();
        }

        public short getShort(int offset) {
            return this.currentBuffer.getShort(offset);
        }

        public void putShort(short value) {
            this.currentBuffer.putShort(value);
            this.changed = true;
        }

        public void putShort(int offset, short value) {
            this.currentBuffer.putShort(offset, value);
        }

        public void setOffset(int offset) {
            this.currentBuffer.position(offset);
        }

        public int getOffset() {
            return this.currentBuffer.position();
        }

        public long getCurrentPageId() {
            return this.currentPageId;
        }

        public int getCurrentPageSize() {
            return this.currentPageId == -1L ? -1 : this.pageSize;
        }

        public File getCurrentFile() {
            throw new UnsupportedOperationException();
        }

        public void rewind() {
            throw new UnsupportedOperationException("Unsupported in this batching page cache, since it's all about strictly sequential access");
        }

        public boolean next() throws IOException {
            return this.next(this.currentPageId + 1L);
        }

        public boolean next(long pageId) throws IOException {
            if (!this.pinned) {
                this.pinned = true;
                return true;
            }
            this.ensurePagePlacedOver(pageId);
            return true;
        }

        public void close() {
        }

        public boolean shouldRetry() {
            return false;
        }

        private void ensurePagePlacedOver(long pageId) throws IOException {
            if (pageId == this.currentPageId) {
                return;
            }
            this.flush();
            this.placeBufferAt(this.currentBuffer, pageId);
            this.currentPageId = pageId;
            this.highestKnownPageId = Math.max(this.highestKnownPageId, pageId);
            this.prepared(this.currentBuffer);
        }

        protected abstract void placeBufferAt(ByteBuffer var1, long var2) throws IOException;

        protected void readFromChannelIntoBuffer(long pageId) throws IOException {
            this.channel.read(this.prepared(this.currentBuffer), pageId * (long)this.pageSize);
        }

        private void flush() throws IOException {
            if (this.currentPageId == -1L) {
                return;
            }
            this.doFlush();
            this.currentPageId = -1L;
        }

        protected abstract void doFlush() throws IOException;

        protected ByteBuffer prepared(ByteBuffer buffer) {
            buffer.flip();
            buffer.limit(this.pageSize);
            return buffer;
        }

        public long highestKnownPageId() {
            return this.highestKnownPageId;
        }
    }

    private static class BatchingPagedFile
    implements PagedFile {
        private final BatchingPageCursor[] cursors = new BatchingPageCursor[3];
        private final StoreChannel channel;
        private final int pageSize;
        private final Closeable resource;

        public BatchingPagedFile(StoreChannel channel, Writer writer, int pageSize, Closeable resource) throws IOException {
            this.channel = channel;
            this.pageSize = pageSize;
            this.resource = resource;
            this.cursors[1] = new ReadCursor(channel, writer, pageSize);
            this.cursors[2] = new WriteCursor(channel, writer, pageSize);
        }

        public PageCursor io(long pageId, int pf_flags) throws IOException {
            BatchingPageCursor cursor = this.cursor(pf_flags);
            cursor.ensurePagePlacedOver(pageId);
            cursor.pinned = false;
            return cursor;
        }

        private BatchingPageCursor cursor(int pf_flags) {
            assert ((pf_flags & 3) != 0 && (pf_flags & 3) != 3) : "Unexpected set pf flags " + pf_flags;
            return this.cursors[pf_flags & 3];
        }

        public int pageSize() {
            return this.pageSize;
        }

        public void close() throws IOException {
            this.resource.close();
            this.closeFile();
            this.cursors[1].free();
            this.cursors[2].free();
        }

        public void closeFile() throws IOException {
            this.flushAndForce();
            this.channel.close();
        }

        public void flushAndForce() throws IOException {
            this.cursors[1].flush();
            this.cursors[2].flush();
        }

        public void force() throws IOException {
        }

        public long getLastPageId() throws IOException {
            return Math.max(this.cursors[1].highestKnownPageId(), this.cursors[2].highestKnownPageId);
        }
    }

    public static interface Writer {
        public void write(ByteBuffer var1, long var2, Pool<ByteBuffer> var4) throws IOException;
    }

    public static interface WriterFactory
    extends Parallelizable {
        public Writer create(StoreChannel var1, Monitor var2);

        public void awaitEverythingWritten();

        public void shutdown();
    }
}

