/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongBitsManipulator;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Encoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.IdGroup;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.NumberArrayStats;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.ParallelSort;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Radix;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.SameGroupDetector;
import org.neo4j.unsafe.impl.batchimport.input.Group;

public class EncodingIdMapper
implements IdMapper {
    public static final Monitor NO_MONITOR = new Monitor(){

        @Override
        public void numberOfCollisions(int numberOfCollisions) {
        }
    };
    private static LongBitsManipulator COLLISION_BIT = new LongBitsManipulator(56, 1);
    public static int CACHE_CHUNK_SIZE = 1000000;
    private final NumberArrayFactory cacheFactory;
    private LongArray dataCache;
    private final NumberArrayStats dataStats = new NumberArrayStats();
    private IntArray trackerCache;
    private final NumberArrayStats trackerStats = new NumberArrayStats();
    private final Encoder encoder;
    private final Radix radix;
    private final int processorsForSorting;
    private final LongArray collisionCache;
    private final List<Object> collisionValues = new ArrayList<Object>();
    private boolean readyForUse;
    private long[][] sortBuckets;
    private IdGroup[] idGroups = new IdGroup[10];
    private IdGroup currentIdGroup;
    private int idGroupsCursor;
    private final Monitor monitor;

    public EncodingIdMapper(NumberArrayFactory cacheFactory, Encoder encoder, Radix radix, Monitor monitor) {
        this(cacheFactory, encoder, radix, monitor, CACHE_CHUNK_SIZE, Runtime.getRuntime().availableProcessors() - 1);
    }

    public EncodingIdMapper(NumberArrayFactory cacheFactory, Encoder encoder, Radix radix, Monitor monitor, int chunkSize, int processorsForSorting) {
        this.monitor = monitor;
        this.cacheFactory = cacheFactory;
        this.processorsForSorting = Math.max(processorsForSorting, 1);
        this.dataCache = EncodingIdMapper.newLongArray(cacheFactory, chunkSize);
        this.encoder = encoder;
        this.radix = radix;
        this.collisionCache = EncodingIdMapper.newLongArray(cacheFactory, chunkSize);
    }

    private static LongArray newLongArray(NumberArrayFactory cacheFactory, int chunkSize) {
        return cacheFactory.newDynamicLongArray(chunkSize, -1L);
    }

    @Override
    public long get(Object inputId, Group group) {
        assert (this.readyForUse);
        return this.binarySearch(inputId, group.id());
    }

    @Override
    public void put(Object inputId, long id, Group group) {
        int groupId = group.id();
        boolean newGroup = false;
        if (this.currentIdGroup == null) {
            newGroup = true;
        } else {
            if (groupId < this.currentIdGroup.id()) {
                throw new IllegalStateException("Nodes for any specific group must be added in sequence before adding nodes for any other group");
            }
            boolean bl = newGroup = groupId != this.currentIdGroup.id();
        }
        if (newGroup) {
            this.endPreviousGroup();
        }
        long code = this.encoder.encode(inputId);
        this.dataCache.set(id, code);
        this.dataStats.register(id);
        this.radix.registerRadixOf(code);
        if (newGroup) {
            if (this.idGroupsCursor >= this.idGroups.length) {
                this.idGroups = Arrays.copyOf(this.idGroups, this.idGroups.length * 2);
            }
            this.idGroups[this.idGroupsCursor++] = this.currentIdGroup = new IdGroup(group, this.dataStats.highestIndex());
        }
    }

    private void endPreviousGroup() {
        if (this.idGroupsCursor > 0) {
            this.idGroups[this.idGroupsCursor - 1].setHighDataIndex(this.dataStats.highestIndex());
        }
    }

    @Override
    public boolean needsPreparation() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(InputIterable<Object> ids, ProgressListener progress) {
        this.endPreviousGroup();
        EncodingIdMapper encodingIdMapper = this;
        synchronized (encodingIdMapper) {
            this.dataCache = this.dataCache.fixate();
            this.trackerCache = this.cacheFactory.newIntArray(this.dataCache.length(), -1);
            try {
                this.sortBuckets = new ParallelSort(this.radix, this.dataCache, this.dataStats, this.trackerCache, this.trackerStats, this.processorsForSorting, progress).run();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new RuntimeException("Got interrupted while preparing the index. Throwing this exception onwards will cause a chain reaction which will cause a panic in the whole import, so mission accomplished");
            }
        }
        if (this.detectAndMarkCollisions(progress) > 0) {
            try (InputIterator<Object> idIterator = ids.iterator();){
                this.buildCollisionInfo(idIterator, progress);
            }
        }
        this.readyForUse = true;
    }

    private int radixOf(long value) {
        return this.radix.calculator().radixOf(value);
    }

    private long binarySearch(Object inputId, int groupId) {
        long returnVal;
        long low = 0L;
        long high = this.trackerStats.highestIndex();
        long x = this.encoder.encode(inputId);
        int rIndex = this.radixOf(x);
        for (int k = 0; k < this.sortBuckets.length; ++k) {
            if ((long)rIndex > this.sortBuckets[k][0]) continue;
            low = this.sortBuckets[k][1];
            high = k == this.sortBuckets.length - 1 ? this.trackerStats.size() - 1L : this.sortBuckets[k + 1][1];
            break;
        }
        if ((returnVal = this.binarySearch(x, inputId, low, high, groupId)) == -1L) {
            low = 0L;
            high = this.trackerStats.size() - 1L;
            returnVal = this.binarySearch(x, inputId, low, high, groupId);
        }
        return returnVal;
    }

    private static long setCollision(long value) {
        return COLLISION_BIT.set(value, 1, 1L);
    }

    static long clearCollision(long value) {
        return COLLISION_BIT.clear(value, 1, false);
    }

    private static boolean isCollision(long value) {
        return COLLISION_BIT.get(value, 1) != 0L;
    }

    private int detectAndMarkCollisions(ProgressListener progress) {
        progress.started("DETECT");
        int numCollisions = 0;
        long max = this.trackerStats.size() - 1L;
        SameGroupDetector sameGroupDetector = new SameGroupDetector();
        int i = 0;
        while ((long)i < max) {
            int batch = (int)Math.min(max - (long)i, 10000L);
            int j = 0;
            while (j < batch) {
                int dataIndexA = this.trackerCache.get(i);
                int dataIndexB = this.trackerCache.get(i + 1);
                if (dataIndexA == -1 || dataIndexB == -1) {
                    sameGroupDetector.reset();
                } else {
                    long dataA = EncodingIdMapper.clearCollision(this.dataCache.get(dataIndexA));
                    long dataB = EncodingIdMapper.clearCollision(this.dataCache.get(dataIndexB));
                    switch (Utils.unsignedDifference(dataA, dataB)) {
                        case GT: {
                            throw new IllegalStateException("Failure:[" + i + "] " + Long.toHexString(dataA) + ":" + Long.toHexString(dataB) + " | " + this.radixOf(dataA) + ":" + this.radixOf(dataB));
                        }
                        case EQ: {
                            int collision = sameGroupDetector.collisionWithinSameGroup(dataIndexA, this.groupOf(dataIndexA).id(), dataIndexB, this.groupOf(dataIndexB).id());
                            if (dataIndexA > dataIndexB) {
                                this.trackerCache.swap(i, i + 1, 1);
                            }
                            if (collision == -1) break;
                            this.markAsCollision(collision);
                            this.markAsCollision(dataIndexB);
                            ++numCollisions;
                            break;
                        }
                        default: {
                            sameGroupDetector.reset();
                        }
                    }
                }
                ++j;
                ++i;
            }
            progress.add(batch);
        }
        progress.done();
        this.monitor.numberOfCollisions(numCollisions);
        return numCollisions;
    }

    private void markAsCollision(int dataIndex) {
        this.dataCache.set(dataIndex, EncodingIdMapper.setCollision(this.dataCache.get(dataIndex)));
    }

    private void buildCollisionInfo(InputIterator<Object> ids, ProgressListener progress) {
        PrimitiveIntObjectMap collidedIds = Primitive.intObjectMap();
        progress.started("RESOLVE");
        long i = 0L;
        while (ids.hasNext()) {
            long j = 0L;
            while (j < 10000L && ids.hasNext()) {
                Object id = ids.next();
                long value = this.dataCache.get(i);
                if (EncodingIdMapper.isCollision(value)) {
                    String existing;
                    IdGroup group = this.groupOf(i);
                    HashMap collisionsForGroup = (HashMap)collidedIds.get(group.id());
                    if (collisionsForGroup == null) {
                        collisionsForGroup = new HashMap();
                        collidedIds.put(group.id(), collisionsForGroup);
                    }
                    if ((existing = (String)collisionsForGroup.get(id)) != null) {
                        throw new IllegalStateException("Id '" + id + "' is defined more than once in " + group.name() + ", at least at " + existing + " and " + this.sourceLocation(ids));
                    }
                    collisionsForGroup.put(id, this.sourceLocation(ids));
                    long val = this.encoder.encode(id);
                    assert (val == EncodingIdMapper.clearCollision(value)) : String.format("Encoding mismatch during building of collision info. input id %s (a %s) marked as collision where this id was encoded into %d when put, but was now encoded into %d", id, id.getClass().getSimpleName(), EncodingIdMapper.clearCollision(value), val);
                    int collisionIndex = this.collisionValues.size();
                    this.collisionValues.add(id);
                    this.collisionCache.set(collisionIndex, i);
                }
                ++j;
                ++i;
            }
            progress.add(j);
        }
        progress.done();
    }

    private String sourceLocation(InputIterator<?> iterator) {
        return iterator.sourceDescription() + ":" + iterator.lineNumber();
    }

    private IdGroup groupOf(long dataIndex) {
        for (IdGroup idGroup : this.idGroups) {
            if (!idGroup.covers(dataIndex)) continue;
            return idGroup;
        }
        throw new IllegalArgumentException("Strange, index " + dataIndex + " isn't included in a group");
    }

    private long binarySearch(long x, Object inputId, long low, long high, int groupId) {
        block4: while (low <= high) {
            long mid = low + (high - low) / 2L;
            int dataIndex = this.trackerCache.get(mid);
            if (dataIndex == -1) {
                return -1L;
            }
            long midValue = this.dataCache.get(dataIndex);
            switch (Utils.unsignedDifference(EncodingIdMapper.clearCollision(midValue), x)) {
                case EQ: {
                    if (mid > 0L && Utils.unsignedCompare(x, this.dataValue(mid - 1L), Utils.CompareType.EQ) || mid < this.trackerStats.highestIndex() && Utils.unsignedCompare(x, this.dataValue(mid + 1L), Utils.CompareType.EQ)) {
                        return this.findFromCollisions(mid, midValue, inputId, groupId);
                    }
                    return this.groupOf(dataIndex).id() == groupId ? (long)dataIndex : -1L;
                }
                case LT: {
                    low = mid + 1L;
                    continue block4;
                }
            }
            high = mid - 1L;
        }
        return -1L;
    }

    private long dataValue(long index) {
        return EncodingIdMapper.clearCollision(this.dataCache.get(this.trackerCache.get(index)));
    }

    private long findIndex(LongArray array, long value) {
        long low = 0L;
        long high = this.dataStats.size() - 1L;
        block4: while (low <= high) {
            long mid = (low + high) / 2L;
            long midValue = array.get(mid);
            switch (Utils.unsignedDifference(midValue, value)) {
                case EQ: {
                    return mid;
                }
                case LT: {
                    low = mid + 1L;
                    continue block4;
                }
            }
            high = mid - 1L;
        }
        return -1L;
    }

    private long findFromCollisions(long index, long val, Object inputId, int groupId) {
        val = EncodingIdMapper.clearCollision(val);
        assert (val == this.encoder.encode(inputId));
        while (index > 0L && Utils.unsignedCompare(val, this.dataValue(index - 1L), Utils.CompareType.EQ)) {
            --index;
        }
        long fromIndex = index;
        while (index < this.trackerStats.highestIndex() && Utils.unsignedCompare(val, this.dataValue(index + 1L), Utils.CompareType.EQ)) {
            ++index;
        }
        long toIndex = index;
        return this.findFromCollisions(fromIndex, toIndex, groupId, inputId);
    }

    private long findFromCollisions(long fromIndex, long toIndex, int groupId, Object inputId) {
        long lowestFound = -1L;
        for (long index = fromIndex; index <= toIndex; ++index) {
            int dataIndex = this.trackerCache.get(index);
            long data = this.dataCache.get(dataIndex);
            IdGroup group = this.groupOf(dataIndex);
            if (groupId != group.id()) continue;
            if (EncodingIdMapper.isCollision(data)) {
                int collisionIndex = Utils.safeCastLongToInt(this.findIndex(this.collisionCache, dataIndex));
                Object value = this.collisionValues.get(collisionIndex);
                if (!inputId.equals(value)) continue;
                lowestFound = lowestFound == -1L ? (long)dataIndex : Math.min(lowestFound, (long)dataIndex);
                continue;
            }
            lowestFound = dataIndex;
            break;
        }
        return lowestFound;
    }

    static boolean compareDataCache(LongArray dataCache, IntArray tracker, int a, int b, Utils.CompareType compareType) {
        int indexA = tracker.get(a);
        int indexB = tracker.get(b);
        if (indexA == -1 || indexB == -1) {
            return false;
        }
        return Utils.unsignedCompare(EncodingIdMapper.clearCollision(dataCache.get(indexA)), EncodingIdMapper.clearCollision(dataCache.get(indexB)), compareType);
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        this.dataCache.acceptMemoryStatsVisitor(visitor);
        if (this.trackerCache != null) {
            this.trackerCache.acceptMemoryStatsVisitor(visitor);
        }
        this.collisionCache.acceptMemoryStatsVisitor(visitor);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.encoder + "," + this.radix + "]";
    }

    public static interface Monitor {
        public void numberOfCollisions(int var1);
    }
}

