/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.graphdb.Direction;
import org.neo4j.unsafe.impl.batchimport.cache.IdFieldManipulator;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NextFieldManipulator;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class NodeRelationshipCache
implements MemoryStatsVisitor.Home {
    private static final long EMPTY = -1L;
    private LongArray array;
    private final int denseNodeThreshold;
    private final RelGroupCache relGroupCache;
    public static final GroupVisitor NO_GROUP_VISITOR = new GroupVisitor(){

        @Override
        public long visit(long nodeId, int type, long next, long out, long in, long loop) {
            return -1L;
        }
    };

    public NodeRelationshipCache(NumberArrayFactory arrayFactory, int denseNodeThreshold) {
        int chunkSize = 1000000;
        this.array = arrayFactory.newDynamicLongArray(chunkSize, IdFieldManipulator.emptyField());
        this.denseNodeThreshold = denseNodeThreshold;
        this.relGroupCache = new RelGroupCache(arrayFactory, chunkSize);
    }

    public int incrementCount(long nodeId) {
        long field = this.array.get(nodeId);
        field = IdFieldManipulator.changeCount(field, 1);
        this.array.set(nodeId, field);
        return IdFieldManipulator.getCount(field);
    }

    public boolean isDense(long nodeId) {
        return this.fieldIsDense(this.array.get(nodeId));
    }

    private boolean fieldIsDense(long field) {
        if ((long)this.denseNodeThreshold == -1L) {
            return false;
        }
        return IdFieldManipulator.getCount(field) >= this.denseNodeThreshold;
    }

    public long getAndPutRelationship(long nodeId, int type, Direction direction, long firstRelId, boolean incrementCount) {
        long field = this.array.get(nodeId);
        long existingId = IdFieldManipulator.getId(field);
        if (this.fieldIsDense(field)) {
            if (existingId == -1L) {
                existingId = this.relGroupCache.allocate(type, direction, firstRelId, incrementCount);
                field = IdFieldManipulator.setId(field, existingId);
                this.array.set(nodeId, field);
                return -1L;
            }
            return this.relGroupCache.putRelationship(existingId, type, direction, firstRelId, incrementCount);
        }
        field = IdFieldManipulator.setId(field, firstRelId);
        this.array.set(nodeId, field);
        return existingId;
    }

    public long getFirstRel(long nodeId, GroupVisitor visitor) {
        long field = this.array.get(nodeId);
        if (this.fieldIsDense(field)) {
            long relGroupIndex = IdFieldManipulator.getId(field);
            return this.relGroupCache.visitGroups(nodeId, relGroupIndex, visitor);
        }
        return IdFieldManipulator.getId(field);
    }

    public void clearRelationships() {
        long length = this.array.length();
        for (long i = 0L; i < length; ++i) {
            long field = this.array.get(i);
            if (this.fieldIsDense(field)) continue;
            field = IdFieldManipulator.cleanId(field);
            this.array.set(i, field);
        }
        this.relGroupCache.clearRelationships();
    }

    public int getCount(long nodeId, int type, Direction direction) {
        long field = this.array.get(nodeId);
        if (this.fieldIsDense(field)) {
            long relGroupIndex = IdFieldManipulator.getId(field);
            if (relGroupIndex == -1L) {
                return 0;
            }
            if ((relGroupIndex = this.relGroupCache.findGroupIndexForType(relGroupIndex, type)) == -1L) {
                return 0;
            }
            field = this.relGroupCache.getField(relGroupIndex, this.relGroupCache.directionIndex(direction));
        }
        return IdFieldManipulator.getCount(field);
    }

    public void fixateNodes() {
        this.array = this.array.fixate();
    }

    public void fixateGroups() {
        this.relGroupCache.fixate();
    }

    public String toString() {
        return this.array.toString();
    }

    public void close() {
        this.array.close();
        this.relGroupCache.close();
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        this.array.acceptMemoryStatsVisitor(visitor);
        this.relGroupCache.acceptMemoryStatsVisitor(visitor);
    }

    private static class RelGroupCache
    implements AutoCloseable,
    MemoryStatsVisitor.Home {
        private static final int ENTRY_SIZE = 4;
        private static final int INDEX_NEXT_AND_TYPE = 0;
        private static final int INDEX_OUT = 1;
        private static final int INDEX_IN = 2;
        private static final int INDEX_LOOP = 3;
        private LongArray array;
        private int nextFreeId = 0;

        RelGroupCache(NumberArrayFactory arrayFactory, long chunkSize) {
            assert (chunkSize > 0L);
            this.array = arrayFactory.newDynamicLongArray(chunkSize, -1L);
        }

        private void clearRelationships() {
            long length = this.array.length() / 4L;
            for (long i = 0L; i < length; ++i) {
                this.clearRelationshipId(i, 1);
                this.clearRelationshipId(i, 2);
                this.clearRelationshipId(i, 3);
            }
        }

        private void clearRelationshipId(long relGroupIndex, int fieldIndex) {
            long index = this.index(relGroupIndex, fieldIndex);
            this.array.set(index, IdFieldManipulator.cleanId(this.array.get(index)));
        }

        private int nextFreeId() {
            return this.nextFreeId++;
        }

        private void initializeGroup(long relGroupIndex, int type) {
            this.setField(relGroupIndex, 0, NextFieldManipulator.initialFieldWithType(type));
            this.setField(relGroupIndex, 1, IdFieldManipulator.emptyField());
            this.setField(relGroupIndex, 2, IdFieldManipulator.emptyField());
            this.setField(relGroupIndex, 3, IdFieldManipulator.emptyField());
        }

        private long visitGroups(long nodeId, long relGroupIndex, GroupVisitor visitor) {
            long currentIndex = relGroupIndex;
            long first = -1L;
            while (currentIndex != -1L) {
                int type = NextFieldManipulator.getType(this.getField(currentIndex, 0));
                long out = IdFieldManipulator.getId(this.getField(currentIndex, 1));
                long in = IdFieldManipulator.getId(this.getField(currentIndex, 2));
                long loop = IdFieldManipulator.getId(this.getField(currentIndex, 3));
                long next = NextFieldManipulator.getNext(this.getField(currentIndex, 0));
                long id = visitor.visit(nodeId, type, next, out, in, loop);
                if (first == -1L) {
                    first = id;
                }
                currentIndex = next;
            }
            return first;
        }

        private void setField(long relGroupIndex, int index, long field) {
            this.array.set(this.index(relGroupIndex, index), field);
        }

        private long getField(long relGroupIndex, int index) {
            return this.array.get(this.index(relGroupIndex, index));
        }

        private int directionIndex(Direction direction) {
            return direction.ordinal() + 1;
        }

        private long index(long relGroupIndex, int fieldIndex) {
            return relGroupIndex * 4L + (long)fieldIndex;
        }

        public long allocate(int type, Direction direction, long relId, boolean incrementCount) {
            long logicalPosition = this.nextFreeId();
            this.initializeGroup(logicalPosition, type);
            this.putRelField(logicalPosition, direction, relId, incrementCount);
            return logicalPosition;
        }

        private long putRelField(long relGroupIndex, Direction direction, long relId, boolean increment) {
            int directionIndex = this.directionIndex(direction);
            long field = this.getField(relGroupIndex, directionIndex);
            long previousId = IdFieldManipulator.getId(field);
            field = IdFieldManipulator.setId(field, relId);
            if (increment) {
                field = IdFieldManipulator.changeCount(field, 1);
            }
            this.setField(relGroupIndex, directionIndex, field);
            return previousId;
        }

        public long putRelationship(long relGroupIndex, int type, Direction direction, long relId, boolean trueForIncrement) {
            long currentIndex = relGroupIndex;
            long previousIndex = -1L;
            while (currentIndex != -1L) {
                long foundType = NextFieldManipulator.getType(this.getField(currentIndex, 0));
                if (foundType == (long)type) {
                    return this.putRelField(currentIndex, direction, relId, trueForIncrement);
                }
                if (foundType > (long)type) break;
                previousIndex = currentIndex;
                currentIndex = NextFieldManipulator.getNext(this.getField(currentIndex, 0));
            }
            long newIndex = this.nextFreeId();
            if (previousIndex == -1L) {
                this.array.swap(this.index(currentIndex, 0), this.index(newIndex, 0), 4);
                long swap = newIndex;
                newIndex = currentIndex;
                currentIndex = swap;
            }
            this.initializeGroup(newIndex, type);
            if (currentIndex != -1L) {
                this.setNextField(newIndex, currentIndex);
            }
            if (previousIndex != -1L) {
                this.setNextField(previousIndex, newIndex);
            }
            return this.putRelField(newIndex, direction, relId, trueForIncrement);
        }

        private void setNextField(long relGroupIndex, long next) {
            long field = this.getField(relGroupIndex, 0);
            field = NextFieldManipulator.setNext(field, next);
            this.setField(relGroupIndex, 0, field);
        }

        private long findGroupIndexForType(long relGroupIndex, int type) {
            long currentIndex = relGroupIndex;
            while (currentIndex != -1L) {
                int foundType = NextFieldManipulator.getType(this.getField(currentIndex, 0));
                if (foundType == type) {
                    return currentIndex;
                }
                if (foundType > type) break;
                currentIndex = NextFieldManipulator.getNext(this.getField(currentIndex, 0));
            }
            return -1L;
        }

        @Override
        public void close() {
            this.array.close();
        }

        @Override
        public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
            this.array.acceptMemoryStatsVisitor(visitor);
        }

        void fixate() {
            this.array = this.array.fixate();
        }
    }

    public static interface GroupVisitor {
        public long visit(long var1, int var3, long var4, long var6, long var8, long var10);
    }
}

