/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.record.NeoStoreUtil;
import org.neo4j.kernel.impl.util.Validator;

public class Validators {
    public static final Validator<File[]> FILES_EXISTS = new Validator<File[]>(){

        @Override
        public void validate(File[] files) {
            for (File file : files) {
                FILE_EXISTS.validate(file);
            }
        }
    };
    public static final Validator<File> FILE_EXISTS = new Validator<File>(){

        @Override
        public void validate(File file) {
            if (!file.exists()) {
                throw new IllegalArgumentException("'" + file + "' doesn't exist");
            }
        }
    };
    public static final Validator<File> DIRECTORY_IS_WRITABLE = new Validator<File>(){

        @Override
        public void validate(File value) {
            if (value.mkdirs()) {
                return;
            }
            File test = new File(value, "_______test___");
            try {
                test.createNewFile();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Directoy '" + value + "' not writable: " + e.getMessage());
            }
            finally {
                test.delete();
            }
        }
    };
    public static final Validator<File> CONTAINS_NO_EXISTING_DATABASE = new Validator<File>(){

        @Override
        public void validate(File value) {
            if (NeoStoreUtil.neoStoreExists((FileSystemAbstraction)new DefaultFileSystemAbstraction(), value)) {
                throw new IllegalArgumentException("Directory '" + value + "' already contains a database");
            }
        }
    };

    public static <T> Validator<T[]> atLeast(final int length) {
        return new Validator<T[]>(){

            @Override
            public void validate(T[] value) {
                if (value.length < length) {
                    throw new IllegalArgumentException("Expected " + Arrays.toString(value) + " to have at least " + length + " items, but had only " + value.length);
                }
            }
        };
    }

    public static final <T> Validator<T> emptyValidator() {
        return new Validator<T>(){

            @Override
            public void validate(T value) {
            }
        };
    }
}

