/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.kernel.impl.util.StringLogger;

public class DurationLogger
implements AutoCloseable {
    private final StringLogger logger;
    private final String tag;
    private long start = 0L;
    private long end = 0L;
    private String outcome = "Not finished";

    public DurationLogger(StringLogger logger, String tag) {
        this.logger = logger;
        this.tag = tag;
        this.start = System.currentTimeMillis();
        logger.debug(String.format("Started: %s", tag));
    }

    public void markAsFinished() {
        this.outcome = null;
    }

    public void markAsAborted(String cause) {
        this.outcome = String.format("Aborted (cause: %s)", cause);
    }

    @Override
    public void close() {
        this.end = System.currentTimeMillis();
        long duration = this.end - this.start;
        if (this.outcome == null) {
            this.logger.debug(String.format("Finished: %s in %d ms", this.tag, duration));
        } else {
            this.logger.warn(String.format("%s: %s in %d ms", this.outcome, this.tag, duration));
        }
    }
}

