/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.progress;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.helpers.ProcessFailureException;

public final class Completion {
    private volatile Collection<Runnable> callbacks = new ArrayList<Runnable>();
    private final List<ProcessFailureException.Entry> processFailureCauses = new ArrayList<ProcessFailureException.Entry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void complete() {
        Collection<Runnable> callbacks = this.callbacks;
        if (callbacks != null) {
            Runnable[] targets;
            Collection<Runnable> collection = callbacks;
            synchronized (collection) {
                targets = callbacks.toArray(new Runnable[callbacks.size()]);
                this.callbacks = null;
            }
            for (Runnable target : targets) {
                try {
                    target.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void signalFailure(String part, Throwable e) {
        this.processFailureCauses.add(new ProcessFailureException.Entry(part, e));
        this.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notify(Runnable callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback may not be null");
        }
        Collection<Runnable> callbacks = this.callbacks;
        if (callbacks != null) {
            Collection<Runnable> collection = callbacks;
            synchronized (collection) {
                if (this.callbacks == callbacks) {
                    callbacks.add(callback);
                    callback = null;
                }
            }
        }
        if (callback != null) {
            callback.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ProcessFailureException {
        CountDownLatch latch = null;
        Collection<Runnable> callbacks = this.callbacks;
        if (callbacks != null) {
            Collection<Runnable> collection = callbacks;
            synchronized (collection) {
                if (this.callbacks == callbacks) {
                    latch = new CountDownLatch(1);
                    callbacks.add(new CountDown(latch));
                }
            }
        }
        if (latch != null && !latch.await(timeout, unit)) {
            throw new TimeoutException(String.format("Process did not complete within %d %s.", timeout, unit.name()));
        }
        if (!this.processFailureCauses.isEmpty()) {
            throw new ProcessFailureException(this.processFailureCauses);
        }
    }

    private static final class CountDown
    implements Runnable {
        private final CountDownLatch latch;

        CountDown(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void run() {
            this.latch.countDown();
        }
    }
}

