/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.OutputStream;
import java.io.PrintStream;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;

public class BadRelationshipsCollector
implements Collector<InputRelationship> {
    private final PrintStream out;
    private final int tolerance;
    private volatile int badEntries;

    public BadRelationshipsCollector(OutputStream out, int tolerance) {
        this.out = new PrintStream(out);
        this.tolerance = tolerance;
    }

    @Override
    public void collect(InputRelationship relationship, Object specificValue) {
        if (++this.badEntries > this.tolerance) {
            throw new InputException(String.format("Too many bad entries, saw %d where last one was %s refering to missing node %s", this.badEntries, relationship, specificValue));
        }
        this.out.println(specificValue + " in " + relationship);
    }

    @Override
    public void close() {
        this.out.flush();
    }

    @Override
    public int badEntries() {
        return this.badEntries;
    }
}

