/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.EncodingIdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Radix;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.RadixCalculator;

public class ParallelSort {
    private final int[] radixIndexCount;
    private final RadixCalculator radixCalculator;
    private final LongArray dataCache;
    private final IntArray tracker;
    private final int threads;
    private long[][] sortBuckets;
    private final ProgressListener progress;

    public ParallelSort(Radix radix, LongArray dataCache, IntArray tracker, int threads, ProgressListener progress) {
        this.progress = progress;
        this.radixIndexCount = radix.getRadixIndexCounts();
        this.radixCalculator = radix.calculator();
        this.dataCache = dataCache;
        this.tracker = tracker;
        this.threads = threads;
    }

    public long[][] run() {
        int[][] sortParams = this.sortRadix();
        int threadsNeeded = 0;
        for (int i = 0; i < this.threads && sortParams[i][1] != 0; ++i) {
            ++threadsNeeded;
        }
        CountDownLatch waitSignal = new CountDownLatch(1);
        CountDownLatch doneSignal = new CountDownLatch(threadsNeeded);
        SortWorker[] sortWorker = new SortWorker[threadsNeeded];
        this.progress.started("SORT");
        for (int i = 0; i < threadsNeeded && sortParams[i][1] != 0; ++i) {
            sortWorker[i] = new SortWorker(i, sortParams[i][0], sortParams[i][1], waitSignal, doneSignal);
            sortWorker[i].start();
        }
        waitSignal.countDown();
        try {
            doneSignal.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.progress.done();
        }
        return this.sortBuckets;
    }

    private int[][] sortRadix() {
        int[][] rangeParams = new int[this.threads][2];
        int[] bucketRange = new int[this.threads];
        this.sortBuckets = new long[this.threads][2];
        int bucketSize = (int)(this.dataCache.size() / (long)this.threads);
        int count = 0;
        int fullCount = 0;
        rangeParams[0][0] = 0;
        bucketRange[0] = 0;
        this.progress.started("SPLIT");
        int threadIndex = 0;
        for (int i = 0; i < this.radixIndexCount.length && threadIndex < this.threads; ++i) {
            if (count + this.radixIndexCount[i] > bucketSize) {
                bucketRange[threadIndex] = count == 0 ? i : i - 1;
                rangeParams[threadIndex][0] = fullCount;
                if (count != 0) {
                    rangeParams[threadIndex][1] = count;
                    fullCount += count;
                    this.progress.add(count);
                    count = this.radixIndexCount[i];
                } else {
                    rangeParams[threadIndex][1] = this.radixIndexCount[i];
                    fullCount += this.radixIndexCount[i];
                    this.progress.add(this.radixIndexCount[i]);
                }
                ++threadIndex;
            } else {
                count += this.radixIndexCount[i];
            }
            if (threadIndex != this.threads - 1 && i != this.radixIndexCount.length - 1) continue;
            bucketRange[threadIndex] = this.radixIndexCount.length;
            rangeParams[threadIndex][0] = fullCount;
            rangeParams[threadIndex][1] = (int)this.dataCache.size() - fullCount;
            break;
        }
        this.progress.done();
        int[] bucketIndex = new int[this.threads];
        for (int i = 0; i < this.threads; ++i) {
            bucketIndex[i] = 0;
        }
        block2: for (long i = 0L; i < this.dataCache.size(); ++i) {
            int rIndex = this.radixCalculator.radixOf(this.dataCache.get(i));
            for (int k = 0; k < this.threads; ++k) {
                if (rIndex > bucketRange[k]) continue;
                int n = k;
                int n2 = bucketIndex[n];
                bucketIndex[n] = n2 + 1;
                long temp = rangeParams[k][0] + n2;
                assert (this.tracker.get(temp) == -1) : "Overlapping buckets i:" + i + ", k:" + k + "\n" + this.dumpBuckets(rangeParams, bucketRange, bucketIndex);
                this.tracker.set(temp, (int)i);
                if (bucketIndex[k] != rangeParams[k][1]) continue block2;
                this.sortBuckets[k][0] = bucketRange[k];
                this.sortBuckets[k][1] = rangeParams[k][0];
                continue block2;
            }
        }
        return rangeParams;
    }

    private String dumpBuckets(int[][] rangeParams, int[] bucketRange, int[] bucketIndex) {
        StringBuilder builder = new StringBuilder();
        builder.append("rangeParams:\n");
        for (int[] range : rangeParams) {
            builder.append("  ").append(Arrays.toString(range)).append("\n");
        }
        builder.append("bucketRange:\n");
        for (int range : bucketRange) {
            builder.append("  ").append(range).append("\n");
        }
        builder.append("bucketIndex:\n");
        for (int index : bucketIndex) {
            builder.append("  ").append(index).append("\n");
        }
        return builder.toString();
    }

    private int partition(int leftIndex, int rightIndex, int pivotIndex) {
        int li = leftIndex;
        int ri = rightIndex - 2;
        int pi = pivotIndex;
        long pivot = EncodingIdMapper.clearCollision(this.dataCache.get(this.tracker.get(pi)));
        this.tracker.swap(pi, rightIndex - 1, 1);
        long left = 0L;
        long right = 0L;
        while (li < ri) {
            left = EncodingIdMapper.clearCollision(this.dataCache.get(this.tracker.get(li)));
            right = EncodingIdMapper.clearCollision(this.dataCache.get(this.tracker.get(ri)));
            if (Utils.unsignedCompare(left, pivot, Utils.CompareType.LT)) {
                ++li;
                continue;
            }
            if (Utils.unsignedCompare(right, pivot, Utils.CompareType.GE)) {
                --ri;
                continue;
            }
            this.tracker.swap(li, ri, 1);
        }
        int partingIndex = ri;
        right = EncodingIdMapper.clearCollision(this.dataCache.get(this.tracker.get(ri)));
        if (Utils.unsignedCompare(right, pivot, Utils.CompareType.LT)) {
            ++partingIndex;
        }
        this.tracker.swap(rightIndex - 1, partingIndex, 1);
        return partingIndex;
    }

    private void recursiveQsort(int start, int end, Random random, SortWorker workerProgress) {
        int diff = end - start;
        if (diff < 2) {
            workerProgress.incrementProgress(diff);
            return;
        }
        workerProgress.incrementProgress(1);
        int pivot = start + random.nextInt(diff);
        pivot = this.partition(start, end, pivot);
        this.recursiveQsort(start, pivot, random, workerProgress);
        this.recursiveQsort(pivot + 1, end, random, workerProgress);
    }

    private class SortWorker
    extends Thread {
        private final int start;
        private final int size;
        private final CountDownLatch doneSignal;
        private final CountDownLatch waitSignal;
        private int workerId = -1;
        private int threadLocalProgress;

        SortWorker(int workerId, int startRange, int size, CountDownLatch wait, CountDownLatch done) {
            this.start = startRange;
            this.size = size;
            this.doneSignal = done;
            this.waitSignal = wait;
            this.workerId = workerId;
        }

        void incrementProgress(int diff) {
            this.threadLocalProgress += diff;
            if (this.threadLocalProgress == 10000) {
                this.reportProgress();
            }
        }

        private void reportProgress() {
            ParallelSort.this.progress.add(this.threadLocalProgress);
            this.threadLocalProgress = 0;
        }

        @Override
        public void run() {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            this.setName("SortWorker-" + this.workerId);
            try {
                this.waitSignal.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ParallelSort.this.recursiveQsort(this.start, this.start + this.size, random, this);
            this.reportProgress();
            this.doneSignal.countDown();
        }
    }
}

