/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Arrays;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Format;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapLongArray;

public interface NumberArrayFactory {
    public static final NumberArrayFactory HEAP = new Adapter(){

        @Override
        public IntArray newIntArray(long length, int defaultValue) {
            return new HeapIntArray(Utils.safeCastLongToInt(length), defaultValue);
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue) {
            return new HeapLongArray(Utils.safeCastLongToInt(length), defaultValue);
        }

        public String toString() {
            return "HEAP";
        }
    };
    public static final NumberArrayFactory OFF_HEAP = new Adapter(){

        @Override
        public IntArray newIntArray(long length, int defaultValue) {
            return new OffHeapIntArray(length, defaultValue);
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue) {
            return new OffHeapLongArray(length, defaultValue);
        }

        public String toString() {
            return "OFF_HEAP";
        }
    };
    public static final NumberArrayFactory CHUNKED_FIXED_SIZE = new Adapter(){
        private final NumberArrayFactory delegate = new Auto(OFF_HEAP, HEAP);

        @Override
        public LongArray newLongArray(long length, long defaultValue) {
            return this.newDynamicLongArray(this.fractionOf(length), defaultValue);
        }

        @Override
        public IntArray newIntArray(long length, int defaultValue) {
            return this.newDynamicIntArray(this.fractionOf(length), defaultValue);
        }

        private long fractionOf(long length) {
            return length / 10L;
        }

        @Override
        public IntArray newDynamicIntArray(long chunkSize, int defaultValue) {
            return new DynamicIntArray(this.delegate, chunkSize, defaultValue);
        }

        @Override
        public LongArray newDynamicLongArray(long chunkSize, long defaultValue) {
            return new DynamicLongArray(this.delegate, chunkSize, defaultValue);
        }

        public String toString() {
            return "CHUNKED_FIXED_SIZE";
        }
    };
    public static final NumberArrayFactory AUTO = new Auto(OFF_HEAP, HEAP, CHUNKED_FIXED_SIZE);

    public IntArray newIntArray(long var1, int var3);

    public IntArray newDynamicIntArray(long var1, int var3);

    public LongArray newLongArray(long var1, long var3);

    public LongArray newDynamicLongArray(long var1, long var3);

    public static class Auto
    extends Adapter {
        private final NumberArrayFactory[] candidates;

        public Auto(NumberArrayFactory ... candidates) {
            this.candidates = candidates;
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue) {
            OutOfMemoryError error = null;
            for (NumberArrayFactory candidate : this.candidates) {
                try {
                    return candidate.newLongArray(length, defaultValue);
                }
                catch (OutOfMemoryError e) {
                    error = e;
                }
            }
            throw this.error(length, 8, error);
        }

        @Override
        public IntArray newIntArray(long length, int defaultValue) {
            OutOfMemoryError error = null;
            for (NumberArrayFactory candidate : this.candidates) {
                try {
                    return candidate.newIntArray(length, defaultValue);
                }
                catch (OutOfMemoryError e) {
                    error = e;
                }
            }
            throw this.error(length, 4, error);
        }

        private OutOfMemoryError error(long length, int itemSize, OutOfMemoryError error) {
            throw Exceptions.withMessage(error, String.format("%s: Not enough memory available for allocating %s, tried %s", error.getMessage(), Format.bytes(length * (long)itemSize), Arrays.toString(this.candidates)));
        }
    }

    public static abstract class Adapter
    implements NumberArrayFactory {
        @Override
        public IntArray newDynamicIntArray(long chunkSize, int defaultValue) {
            return new DynamicIntArray(this, chunkSize, defaultValue);
        }

        @Override
        public LongArray newDynamicLongArray(long chunkSize, long defaultValue) {
            return new DynamicLongArray(this, chunkSize, defaultValue);
        }
    }
}

