/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Collection;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.unsafe.impl.batchimport.IoThroughputStat;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class UpdateRecordsStep<RECORD extends AbstractBaseRecord>
extends ExecutorServiceStep<RECORD[]>
implements StatsProvider {
    private final RecordStore<RECORD> store;
    private final int recordSize;
    private int recordsUpdated;

    public UpdateRecordsStep(StageControl control, int workAheadSize, int movingAverageSize, RecordStore<RECORD> store) {
        super(control, "v", workAheadSize, movingAverageSize, 1, new StatsProvider[0]);
        this.store = store;
        this.recordSize = store.getRecordSize();
    }

    @Override
    protected Object process(long ticket, RECORD[] batch) {
        for (RECORD record : batch) {
            if (record == null) continue;
            this.store.updateRecord(record);
        }
        this.recordsUpdated += batch.length;
        return null;
    }

    @Override
    protected void collectStatsProviders(Collection<StatsProvider> into) {
        super.collectStatsProviders(into);
        into.add(this);
    }

    @Override
    public Stat stat(Key key) {
        return key == Keys.io_throughput ? new IoThroughputStat(this.startTime, this.endTime, this.recordSize * this.recordsUpdated) : null;
    }

    @Override
    public Key[] keys() {
        return new Keys[]{Keys.io_throughput};
    }
}

