/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Arrays;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.util.MovingAverage;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RelativeIdRecordAllocator;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class PropertyEncoderStep<RECORD extends PrimitiveRecord, INPUT extends InputEntity>
extends ExecutorServiceStep<Batch<INPUT, RECORD>> {
    private final BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyHolder;
    private final int arrayDataSize;
    private final int stringDataSize;
    private final MovingAverage averageBlocksPerBatch;

    protected PropertyEncoderStep(StageControl control, Configuration config, int numberOfExecutors, BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyHolder, PropertyStore propertyStore) {
        super(control, "PROPERTIES", config.workAheadSize(), config.movingAverageSize(), numberOfExecutors, true, new StatsProvider[0]);
        this.propertyKeyHolder = propertyKeyHolder;
        this.arrayDataSize = propertyStore.getArrayStore().dataSize();
        this.stringDataSize = propertyStore.getStringStore().dataSize();
        this.averageBlocksPerBatch = new MovingAverage(config.movingAverageSize());
    }

    @Override
    protected Object process(long ticket, Batch<INPUT, RECORD> batch) {
        RelativeIdRecordAllocator stringAllocator = new RelativeIdRecordAllocator(this.stringDataSize);
        RelativeIdRecordAllocator arrayAllocator = new RelativeIdRecordAllocator(this.arrayDataSize);
        PropertyCreator propertyCreator = new PropertyCreator(stringAllocator, arrayAllocator, null, null);
        int blockCountGuess = (int)this.averageBlocksPerBatch.average();
        PropertyBlock[] propertyBlocks = new PropertyBlock[blockCountGuess == 0 ? ((InputEntity[])batch.input).length : blockCountGuess + ((InputEntity[])batch.input).length / 20];
        int blockCursor = 0;
        for (int i = 0; i < ((InputEntity[])batch.input).length; ++i) {
            stringAllocator.initialize();
            arrayAllocator.initialize();
            InputEntity input = ((InputEntity[])batch.input)[i];
            if (input.hasFirstPropertyId()) continue;
            int count = input.properties().length >> 1;
            if (blockCursor + count > propertyBlocks.length) {
                propertyBlocks = Arrays.copyOf(propertyBlocks, propertyBlocks.length << 1);
            }
            this.propertyKeyHolder.propertyKeysAndValues(propertyBlocks, blockCursor, input.properties(), propertyCreator);
            batch.propertyBlocksLengths[i] = count;
            blockCursor += count;
        }
        batch.propertyBlocks = propertyBlocks;
        this.averageBlocksPerBatch.add(blockCursor);
        return batch;
    }
}

