/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.collection.pool.Pool;

public class SimplePool<T>
implements Pool<T> {
    private final T[] items;
    private final boolean[] acquiredMarkers;

    public SimplePool(T[] items) {
        this.items = items;
        this.acquiredMarkers = new boolean[items.length];
    }

    public synchronized T acquire() {
        int availableItemIndex;
        while ((availableItemIndex = this.firstAvailableItemIndex()) == -1) {
            try {
                this.wait(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.acquiredMarkers[availableItemIndex] = true;
        return this.items[availableItemIndex];
    }

    public synchronized void release(T item) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != item) continue;
            this.acquiredMarkers[i] = false;
            this.notifyAll();
            return;
        }
        throw new IllegalArgumentException("Item " + item + " does not belong to the pool");
    }

    private int firstAvailableItemIndex() {
        for (int i = 0; i < this.acquiredMarkers.length; ++i) {
            boolean itemIsAcquired = this.acquiredMarkers[i];
            if (itemIsAcquired) continue;
            return i;
        }
        return -1;
    }
}

