/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.Abstract64BitRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;

public class HighIdTransactionApplier
implements NeoCommandHandler {
    private final NeoCommandHandler delegate;
    private final NeoStore neoStore;
    private final Map<CommonAbstractStore, HighId> highIds = new HashMap<CommonAbstractStore, HighId>();

    public HighIdTransactionApplier(NeoCommandHandler delegate, NeoStore neoStore) {
        this.delegate = delegate;
        this.neoStore = neoStore;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        NodeStore nodeStore = this.neoStore.getNodeStore();
        this.track((CommonAbstractStore)nodeStore, command);
        this.track((CommonAbstractStore)nodeStore.getDynamicLabelStore(), command.getAfter().getDynamicLabelRecords());
        return this.delegate.visitNodeCommand(command);
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
        this.track((CommonAbstractStore)this.neoStore.getRelationshipStore(), command);
        return this.delegate.visitRelationshipCommand(command);
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
        PropertyStore propertyStore = this.neoStore.getPropertyStore();
        this.track((CommonAbstractStore)propertyStore, command);
        for (PropertyBlock block : command.getAfter()) {
            switch (block.getType()) {
                case STRING: {
                    this.track((CommonAbstractStore)propertyStore.getStringStore(), block.getValueRecords());
                    break;
                }
                case ARRAY: {
                    this.track((CommonAbstractStore)propertyStore.getArrayStore(), block.getValueRecords());
                    break;
                }
            }
        }
        return this.delegate.visitPropertyCommand(command);
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
        this.track((CommonAbstractStore)this.neoStore.getRelationshipGroupStore(), command);
        return this.delegate.visitRelationshipGroupCommand(command);
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
        this.trackToken(this.neoStore.getRelationshipTypeTokenStore(), command);
        return this.delegate.visitRelationshipTypeTokenCommand(command);
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
        this.trackToken(this.neoStore.getLabelTokenStore(), command);
        return this.delegate.visitLabelTokenCommand(command);
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
        this.trackToken(this.neoStore.getPropertyKeyTokenStore(), command);
        return this.delegate.visitPropertyKeyTokenCommand(command);
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
        SchemaStore schemaStore = this.neoStore.getSchemaStore();
        for (DynamicRecord record : command.getRecordsAfter()) {
            this.track((CommonAbstractStore)schemaStore, record.getId());
        }
        return this.delegate.visitSchemaRuleCommand(command);
    }

    @Override
    public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) throws IOException {
        this.delegate.visitNeoStoreCommand(command);
        return false;
    }

    @Override
    public boolean visitIndexAddNodeCommand(IndexCommand.AddNodeCommand command) throws IOException {
        return this.delegate.visitIndexAddNodeCommand(command);
    }

    @Override
    public boolean visitIndexAddRelationshipCommand(IndexCommand.AddRelationshipCommand command) throws IOException {
        return this.delegate.visitIndexAddRelationshipCommand(command);
    }

    @Override
    public boolean visitIndexRemoveCommand(IndexCommand.RemoveCommand command) throws IOException {
        return this.delegate.visitIndexRemoveCommand(command);
    }

    @Override
    public boolean visitIndexDeleteCommand(IndexCommand.DeleteCommand command) throws IOException {
        return this.delegate.visitIndexDeleteCommand(command);
    }

    @Override
    public boolean visitIndexCreateCommand(IndexCommand.CreateCommand command) throws IOException {
        return this.delegate.visitIndexCreateCommand(command);
    }

    @Override
    public boolean visitIndexDefineCommand(IndexDefineCommand command) throws IOException {
        return this.delegate.visitIndexDefineCommand(command);
    }

    @Override
    public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) throws IOException {
        return this.delegate.visitNodeCountsCommand(command);
    }

    @Override
    public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) throws IOException {
        return this.delegate.visitRelationshipCountsCommand(command);
    }

    @Override
    public void apply() {
        this.delegate.apply();
        for (Map.Entry<CommonAbstractStore, HighId> highId : this.highIds.entrySet()) {
            highId.getKey().setHighestPossibleIdInUse(highId.getValue().id);
        }
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private void track(CommonAbstractStore store, long id) {
        HighId highId = this.highIds.get(store);
        if (highId == null) {
            highId = new HighId(id);
            this.highIds.put(store, highId);
        } else {
            highId.track(id);
        }
    }

    private void track(CommonAbstractStore store, Command command) {
        this.track(store, command.getKey());
    }

    private void track(CommonAbstractStore store, Collection<? extends Abstract64BitRecord> records) {
        for (Abstract64BitRecord abstract64BitRecord : records) {
            this.track(store, abstract64BitRecord.getId());
        }
    }

    private <RECORD extends TokenRecord> void trackToken(TokenStore<RECORD> tokenStore, Command.TokenCommand<RECORD> tokenCommand) {
        this.track(tokenStore, tokenCommand);
        this.track((CommonAbstractStore)tokenStore.getNameStore(), ((TokenRecord)tokenCommand.getRecord()).getNameRecords());
    }

    private static class HighId {
        private long id;

        public HighId(long id) {
            this.id = id;
        }

        void track(long id) {
            if (id > this.id) {
                this.id = id;
            }
        }
    }
}

