/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.AbstractRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.util.StringLogger;

public class DumpStore<RECORD extends AbstractBaseRecord, STORE extends CommonAbstractStore> {
    private final PrintStream out;

    public static void main(String ... args) throws Exception {
        if (args == null || args.length == 0) {
            System.err.println("WARNING: no files specified...");
            return;
        }
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        try (PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs);){
            DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory();
            StoreFactory storeFactory = new StoreFactory(new Config(), idGeneratorFactory, pageCache, (FileSystemAbstraction)fs, DumpStore.logger(), null);
            for (String arg : args) {
                DumpStore.dumpFile(storeFactory, arg);
            }
        }
    }

    private static void dumpFile(StoreFactory storeFactory, String arg) throws Exception {
        File file = new File(arg);
        if (!file.isFile()) {
            throw new IllegalArgumentException("No such file: " + arg);
        }
        switch (file.getName()) {
            case "neostore.nodestore.db": {
                DumpStore.dumpNodeStore(file, storeFactory);
                break;
            }
            case "neostore.relationshipstore.db": {
                DumpStore.dumpRelationshipStore(file, storeFactory);
                break;
            }
            case "neostore.propertystore.db": {
                DumpStore.dumpPropertyStore(file, storeFactory);
                break;
            }
            case "neostore.schemastore.db": {
                DumpStore.dumpSchemaStore(file, storeFactory);
                break;
            }
            case "neostore.propertystore.db.index": {
                DumpStore.dumpPropertyKeys(file, storeFactory);
                break;
            }
            case "neostore.labeltokenstore.db": {
                DumpStore.dumpLabels(file, storeFactory);
                break;
            }
            case "neostore.relationshiptypestore.db": {
                DumpStore.dumpRelationshipTypes(file, storeFactory);
                break;
            }
            case "neostore.relationshipgroupstore.db": {
                DumpStore.dumpRelationshipGroups(file, storeFactory);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown store file: " + arg);
            }
        }
    }

    private static StringLogger logger() {
        return Boolean.getBoolean("logger") ? StringLogger.SYSTEM : StringLogger.DEV_NULL;
    }

    private static void dumpPropertyKeys(File file, StoreFactory storeFactory) throws Exception {
        DumpStore.dumpTokens(storeFactory.newPropertyKeyTokenStore(file));
    }

    private static void dumpLabels(File file, StoreFactory storeFactory) throws Exception {
        DumpStore.dumpTokens(storeFactory.newLabelTokenStore(file));
    }

    private static void dumpRelationshipTypes(File file, StoreFactory storeFactory) throws Exception {
        DumpStore.dumpTokens(storeFactory.newRelationshipTypeTokenStore(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends TokenRecord> void dumpTokens(final TokenStore<T> store) throws Exception {
        try {
            new DumpStore<T, TokenStore<T>>(System.out){

                @Override
                protected Object transform(T record) throws Exception {
                    if (((AbstractBaseRecord)record).inUse()) {
                        store.ensureHeavy(record);
                        return ((AbstractRecord)record).getId() + ": \"" + store.getStringFor(record) + "\": " + record;
                    }
                    return null;
                }
            }.dump(store);
        }
        finally {
            store.close();
        }
    }

    private static void dumpRelationshipGroups(File file, StoreFactory storeFactory) throws Exception {
        try (RelationshipGroupStore store = storeFactory.newRelationshipGroupStore(file);){
            new DumpStore(System.out).dump(store);
        }
    }

    private static void dumpRelationshipStore(File file, StoreFactory storeFactory) throws Exception {
        try (RelationshipStore store = storeFactory.newRelationshipStore(file);){
            new DumpStore(System.out).dump(store);
        }
    }

    private static void dumpPropertyStore(File file, StoreFactory storeFactory) throws Exception {
        try (PropertyStore store = storeFactory.newPropertyStore(file);){
            new DumpStore(System.out).dump(store);
        }
    }

    private static void dumpSchemaStore(File file, StoreFactory storeFactory) throws Exception {
        try (SchemaStore store = storeFactory.newSchemaStore(file);){
            final SchemaStorage storage = new SchemaStorage(store);
            new DumpStore<DynamicRecord, SchemaStore>(System.out){

                @Override
                protected Object transform(DynamicRecord record) throws Exception {
                    return record.inUse() && record.isStartRecord() ? storage.loadSingleSchemaRule(record.getId()) : null;
                }
            }.dump(store);
        }
    }

    private static void dumpNodeStore(File file, StoreFactory storeFactory) throws Exception {
        try (NodeStore store = storeFactory.newNodeStore(file);){
            new DumpStore<NodeRecord, NodeStore>(System.out){

                @Override
                protected Object transform(NodeRecord record) throws Exception {
                    return record.inUse() ? record : "";
                }
            }.dump(store);
        }
    }

    protected DumpStore(PrintStream out) {
        this.out = out;
    }

    public final void dump(STORE store) throws Exception {
        ((CommonAbstractStore)store).makeStoreOk();
        int size = ((CommonAbstractStore)store).getRecordSize();
        StoreChannel fileChannel = ((CommonAbstractStore)store).getFileChannel();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        this.out.println("store.getRecordSize() = " + size);
        this.out.println("<dump>");
        long used = 0L;
        long high = ((CommonAbstractStore)store).getHighestPossibleIdInUse();
        for (long i = 0L; i <= high; ++i) {
            Object transform;
            Object record = ((RecordStore)store).forceGetRecord(i);
            if (((AbstractBaseRecord)record).inUse()) {
                ++used;
            }
            if ((transform = this.transform(record)) != null) {
                if ("".equals(transform)) continue;
                this.out.println(transform);
                continue;
            }
            this.out.print(record);
            buffer.clear();
            fileChannel.read(buffer, i * (long)size);
            buffer.flip();
            if (((AbstractBaseRecord)record).inUse()) {
                this.dumpHex(buffer, i * (long)size);
                continue;
            }
            if (this.allZero(buffer)) {
                this.out.printf(": all zeros @ 0x%x - 0x%x%n", i * (long)size, (i + 1L) * (long)size);
                continue;
            }
            this.dumpHex(buffer, i * (long)size);
        }
        this.out.println("</dump>");
        this.out.printf("used = %s / highId = %s (%.2f%%)%n", used, ((CommonAbstractStore)store).getHighId(), (double)used * 100.0 / (double)((CommonAbstractStore)store).getHighId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allZero(ByteBuffer buffer) {
        int pos = buffer.position();
        try {
            while (buffer.remaining() > 0) {
                if (buffer.get() == 0) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            buffer.position(pos);
        }
        return true;
    }

    protected Object transform(RECORD record) throws Exception {
        return ((AbstractBaseRecord)record).inUse() ? record : null;
    }

    private void dumpHex(ByteBuffer buffer, long offset) {
        int count = 0;
        while (buffer.remaining() > 0) {
            byte b = buffer.get();
            if (count % 16 == 0) {
                this.out.printf("%n    @ 0x%08x: ", offset);
            } else if (count % 4 == 0) {
                this.out.print(" ");
            }
            this.out.printf(" %x%x", 0xF & b >> 4, 0xF & b);
            ++count;
            ++offset;
        }
        this.out.println();
    }
}

