/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.staging.IoProducerStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class IteratorBatcherStep<T>
extends IoProducerStep<T[]> {
    private final InputIterator<T> data;
    private final Class<T> itemClass;

    public IteratorBatcherStep(StageControl control, int batchSize, int movingAverageSize, InputIterator<T> data, Class<T> itemClass) {
        super(control, batchSize, movingAverageSize);
        this.data = data;
        this.itemClass = itemClass;
    }

    @Override
    protected Object nextBatchOrNull(int batchSize) {
        int i;
        if (!this.data.hasNext()) {
            return null;
        }
        Object[] batch = (Object[])Array.newInstance(this.itemClass, batchSize);
        for (i = 0; i < batchSize && this.data.hasNext(); ++i) {
            batch[i] = this.data.next();
        }
        return i == batchSize ? batch : Arrays.copyOf(batch, i);
    }

    @Override
    public void close() {
        this.data.close();
    }

    @Override
    protected long position() {
        return this.data.position();
    }
}

