/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import org.neo4j.helpers.Clock;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.DynamicProcessorAssigner;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitors;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisor;
import org.neo4j.unsafe.impl.batchimport.staging.MultiExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;

public class ExecutionSupervisors {
    public static void superviseDynamicExecution(Stage ... stages) {
        ExecutionSupervisors.superviseDynamicExecution(ExecutionMonitors.invisible(), Configuration.DEFAULT, stages);
    }

    public static void superviseDynamicExecution(ExecutionMonitor monitor, Stage ... stages) {
        ExecutionSupervisors.superviseDynamicExecution(monitor, Configuration.DEFAULT, stages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void superviseDynamicExecution(ExecutionMonitor monitor, Configuration config, Stage ... stages) {
        DynamicProcessorAssigner dynamicProcessorAssigner = new DynamicProcessorAssigner(config, Math.min(config.maxNumberOfProcessors(), Runtime.getRuntime().availableProcessors()));
        ExecutionSupervisor supervisor = new ExecutionSupervisor(Clock.SYSTEM_CLOCK, new MultiExecutionMonitor(monitor, dynamicProcessorAssigner));
        try {
            StageExecution[] executions = new StageExecution[stages.length];
            for (int i = 0; i < stages.length; ++i) {
                executions[i] = stages[i].execute();
            }
            supervisor.supervise(executions);
        }
        finally {
            for (Stage stage : stages) {
                stage.close();
            }
        }
    }
}

