/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Pair;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;

public class DynamicProcessorAssigner
extends ExecutionMonitor.Adpter {
    private final Configuration config;
    private final Map<Step<?>, Long> lastChangedProcessors = new HashMap();
    private final int availableProcessors;

    public DynamicProcessorAssigner(Configuration config, int availableProcessors) {
        super(500L, TimeUnit.MILLISECONDS);
        this.config = config;
        this.availableProcessors = availableProcessors;
    }

    @Override
    public void start(StageExecution[] executions) {
        this.lastChangedProcessors.clear();
    }

    @Override
    public void check(StageExecution[] executions) {
        int permits = this.availableProcessors - this.countActiveProcessors(executions);
        if (permits <= 0) {
            return;
        }
        for (StageExecution execution : executions) {
            if (!execution.stillExecuting()) continue;
            if (permits > 0) {
                permits -= this.assignProcessorsToPotentialBottleNeck(execution, permits);
            }
            if (!this.removeProcessorFromPotentialIdleStep(execution)) continue;
            ++permits;
        }
    }

    private int assignProcessorsToPotentialBottleNeck(StageExecution execution, int permits) {
        Pair<Step<?>, Float> bottleNeck = execution.stepsOrderedBy(Keys.avg_processing_time, false).iterator().next();
        Step<?> bottleNeckStep = bottleNeck.first();
        long doneBatches = this.batches(bottleNeckStep);
        int usedPermits = 0;
        if (bottleNeck.other().floatValue() > 1.0f && this.batchesPassedSinceLastChange(bottleNeckStep, doneBatches) >= (long)this.config.movingAverageSize()) {
            int optimalProcessorIncrement = Math.min(Math.max(1, (int)bottleNeck.other().floatValue() - 1), permits);
            for (int i = 0; i < optimalProcessorIncrement; ++i) {
                if (!bottleNeckStep.incrementNumberOfProcessors()) continue;
                this.lastChangedProcessors.put(bottleNeckStep, doneBatches);
                ++usedPermits;
            }
        }
        return usedPermits;
    }

    private boolean removeProcessorFromPotentialIdleStep(StageExecution execution) {
        long doneBatches;
        Step<?> fastestStep;
        Pair<Step<?>, Float> fastest = execution.stepsOrderedBy(Keys.avg_processing_time, true).iterator().next();
        float threshold = 1.0f - 1.0f / (float)fastest.first().numberOfProcessors();
        if (fastest.other().floatValue() < threshold && this.batchesPassedSinceLastChange(fastestStep = fastest.first(), doneBatches = this.batches(fastestStep)) >= (long)this.config.movingAverageSize() && fastestStep.decrementNumberOfProcessors()) {
            this.lastChangedProcessors.put(fastestStep, doneBatches);
            return true;
        }
        return false;
    }

    private int avg(Step<?> step) {
        return (int)step.stats().stat(Keys.avg_processing_time).asLong();
    }

    private long batches(Step<?> step) {
        return step.stats().stat(Keys.done_batches).asLong();
    }

    private int countActiveProcessors(StageExecution[] executions) {
        float processors = 0.0f;
        for (StageExecution execution : executions) {
            if (!execution.stillExecuting()) continue;
            long highestAverage = this.avg(execution.stepsOrderedBy(Keys.avg_processing_time, false).iterator().next().first());
            for (Step<?> step : execution.steps()) {
                long avg = this.avg(step);
                float factor = (float)avg / (float)highestAverage;
                processors += factor * (float)step.numberOfProcessors();
            }
        }
        return Math.round(processors);
    }

    private long batchesPassedSinceLastChange(Step<?> step, long doneBatches) {
        return this.lastChangedProcessors.containsKey(step) ? doneBatches - this.lastChangedProcessors.get(step) : (long)this.config.movingAverageSize();
    }
}

