/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.IOException;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Mark;
import org.neo4j.function.Function;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.UnexpectedEndOfInputException;
import org.neo4j.unsafe.impl.batchimport.input.csv.Deserialization;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;

public class InputEntityDeserializer<ENTITY extends InputEntity>
extends PrefetchingIterator<ENTITY>
implements InputIterator<ENTITY> {
    private final Header header;
    private final CharSeeker data;
    private final Mark mark = new Mark();
    private final int delimiter;
    private final Function<ENTITY, ENTITY> decorator;
    private final Deserialization<ENTITY> deserialization;
    private final Validator<ENTITY> validator;

    InputEntityDeserializer(Header header, CharSeeker data, int delimiter, Deserialization<ENTITY> deserialization, Function<ENTITY, ENTITY> decorator, Validator<ENTITY> validator) {
        this.header = header;
        this.data = data;
        this.delimiter = delimiter;
        this.deserialization = deserialization;
        this.decorator = decorator;
        this.validator = validator;
    }

    public void initialize() {
        this.deserialization.initialize();
    }

    @Override
    protected ENTITY fetchNextOrNull() {
        int fieldIndex;
        Header.Entry[] entries = this.header.entries();
        try {
            InputEntity value;
            for (fieldIndex = 0; fieldIndex < entries.length; ++fieldIndex) {
                if (!this.data.seek(this.mark, this.delimiter)) {
                    if (fieldIndex > 0) {
                        throw new UnexpectedEndOfInputException("Near " + this.mark);
                    }
                    ENTITY ENTITY = null;
                    return ENTITY;
                }
                Header.Entry entry = entries[fieldIndex];
                if (entry.type() != Type.IGNORE) {
                    value = this.data.tryExtract(this.mark, entry.extractor()) ? entry.extractor().value() : null;
                    this.deserialization.handle(entry, value);
                }
                if (this.mark.isEndOfLine()) break;
            }
            InputEntity entity = (InputEntity)this.deserialization.materialize();
            while (!this.mark.isEndOfLine()) {
                this.data.seek(this.mark, this.delimiter);
            }
            entity = (InputEntity)this.decorator.apply((Object)entity);
            this.validator.validate(entity);
            value = entity;
            return (ENTITY)value;
        }
        catch (IOException e) {
            throw new InputException("Unable to read more data from input stream", e);
        }
        catch (RuntimeException e) {
            String stringValue = null;
            try {
                Extractors extractors = new Extractors('?');
                if (this.data.tryExtract(this.mark, extractors.string())) {
                    stringValue = (String)extractors.string().value();
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            String message = String.format("ERROR in input%n  data source: %s%n  in field: %s%n  for header: %s%n  raw field value: %s%n  original error: %s", this.data, entries[fieldIndex] + ":" + (fieldIndex + 1), this.header, stringValue != null ? stringValue : "??", e.getMessage());
            if (e instanceof InputException) {
                throw Exceptions.withMessage(e, message);
            }
            throw new InputException(message, e);
        }
        finally {
            this.deserialization.clear();
        }
    }

    @Override
    public void close() {
        try {
            this.data.close();
        }
        catch (IOException e) {
            throw new InputException("Unable to close data iterator", e);
        }
    }

    public long position() {
        return this.data.position();
    }

    public String sourceDescription() {
        return this.data.sourceDescription();
    }

    public long lineNumber() {
        return this.data.lineNumber();
    }
}

