/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

public interface Configuration {
    public static final Configuration COMMAS = new Default(){

        @Override
        public char delimiter() {
            return ',';
        }

        @Override
        public char arrayDelimiter() {
            return ';';
        }
    };
    public static final Configuration TABS = new Default(){

        @Override
        public char delimiter() {
            return '\t';
        }

        @Override
        public char arrayDelimiter() {
            return ',';
        }
    };

    public char delimiter();

    public char arrayDelimiter();

    public char quotationCharacter();

    public int bufferSize();

    public static class OverrideFromConfig
    implements Configuration {
        private final Configuration defaults;

        public OverrideFromConfig(Configuration defaults) {
            this.defaults = defaults;
        }

        @Override
        public char delimiter() {
            return this.defaults.delimiter();
        }

        @Override
        public char arrayDelimiter() {
            return this.defaults.arrayDelimiter();
        }

        @Override
        public char quotationCharacter() {
            return this.defaults.quotationCharacter();
        }

        @Override
        public int bufferSize() {
            return this.defaults.bufferSize();
        }
    }

    public static abstract class Default
    implements Configuration {
        @Override
        public char quotationCharacter() {
            return '\"';
        }

        @Override
        public int bufferSize() {
            return 0x800000;
        }
    }
}

