/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class RelationshipEncoderStep
extends ExecutorServiceStep<Batch<InputRelationship, RelationshipRecord>> {
    private final BatchingTokenRepository<?> relationshipTypeRepository;
    private final RelationshipStore relationshipStore;
    private final NodeRelationshipLink nodeRelationshipLink;
    private final boolean specificIds;
    private long nextRelationshipId;

    public RelationshipEncoderStep(StageControl control, Configuration config, BatchingTokenRepository<?> relationshipTypeRepository, RelationshipStore relationshipStore, NodeRelationshipLink nodeRelationshipLink, boolean specificIds) {
        super(control, "RELATIONSHIP", config.workAheadSize(), config.movingAverageSize(), 1);
        this.relationshipTypeRepository = relationshipTypeRepository;
        this.relationshipStore = relationshipStore;
        this.nodeRelationshipLink = nodeRelationshipLink;
        this.specificIds = specificIds;
    }

    @Override
    protected Object process(long ticket, Batch<InputRelationship, RelationshipRecord> batch) {
        InputRelationship[] input = (InputRelationship[])batch.input;
        batch.records = new RelationshipRecord[input.length];
        long[] ids = batch.ids;
        for (int i = 0; i < input.length; ++i) {
            long l;
            InputRelationship batchRelationship = input[i];
            if (this.specificIds != batchRelationship.hasSpecificId()) {
                throw new IllegalStateException("Input was declared to have specificRelationshipIds=" + this.specificIds + ", but " + batchRelationship + " didn't honor that");
            }
            if (this.specificIds) {
                l = batchRelationship.specificId();
            } else {
                long l2 = this.nextRelationshipId;
                l = l2;
                this.nextRelationshipId = l2 + 1L;
            }
            long relationshipId = l;
            long startNodeId = ids[i * 2];
            long endNodeId = ids[i * 2 + 1];
            if (startNodeId == -1L || endNodeId == -1L) {
                ((RelationshipRecord[])batch.records)[i] = null;
                continue;
            }
            this.relationshipStore.setHighestPossibleIdInUse(relationshipId);
            int typeId = batchRelationship.hasTypeId() ? batchRelationship.typeId() : this.relationshipTypeRepository.getOrCreateId(batchRelationship.type());
            RelationshipRecord relationshipRecord = new RelationshipRecord(relationshipId, startNodeId, endNodeId, typeId);
            ((RelationshipRecord[])batch.records)[i] = relationshipRecord;
            RelationshipRecord relationshipRecord2 = relationshipRecord;
            relationshipRecord2.setInUse(true);
            boolean loop = startNodeId == endNodeId;
            long firstNextRel = this.nodeRelationshipLink.getAndPutRelationship(startNodeId, typeId, loop ? Direction.BOTH : Direction.OUTGOING, relationshipId, true);
            relationshipRecord2.setFirstNextRel(firstNextRel);
            if (loop) {
                relationshipRecord2.setSecondNextRel(firstNextRel);
            } else {
                relationshipRecord2.setSecondNextRel(this.nodeRelationshipLink.getAndPutRelationship(endNodeId, typeId, Direction.INCOMING, relationshipId, true));
            }
            relationshipRecord2.setFirstInFirstChain(false);
            relationshipRecord2.setFirstInSecondChain(false);
            relationshipRecord2.setFirstPrevRel(Record.NO_NEXT_RELATIONSHIP.intValue());
            relationshipRecord2.setSecondPrevRel(Record.NO_NEXT_RELATIONSHIP.intValue());
        }
        return batch;
    }
}

