/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.RecordProcessor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;

public class RelationshipCountsProcessor
implements RecordProcessor<RelationshipRecord> {
    private static final boolean COMPUTE_DOUBLE_SIDED_RELATIONSHIP_COUNTS = false;
    private final NodeLabelsCache nodeLabelCache;
    private final long[][][] counts;
    private int[] startScratch = new int[20];
    private int[] endScratch = new int[20];
    private final CountsAccessor.Updater countsUpdater;
    private final int anyLabel;
    private final int anyRelationshipType;

    public RelationshipCountsProcessor(NodeLabelsCache nodeLabelCache, int highLabelId, int highRelationshipTypeId, CountsAccessor.Updater countsUpdater) {
        this.nodeLabelCache = nodeLabelCache;
        this.countsUpdater = countsUpdater;
        this.counts = new long[highLabelId + 1][highRelationshipTypeId + 1][highLabelId + 1];
        this.anyLabel = highLabelId;
        this.anyRelationshipType = highRelationshipTypeId;
    }

    public void process(long startNode, int type, long endNode) {
        long[] lArray = this.counts[this.anyLabel][this.anyRelationshipType];
        int n = this.anyLabel;
        lArray[n] = lArray[n] + 1L;
        long[] lArray2 = this.counts[this.anyLabel][type];
        int n2 = this.anyLabel;
        lArray2[n2] = lArray2[n2] + 1L;
        for (int startNodeLabelId : this.startScratch = this.nodeLabelCache.get(startNode, this.startScratch)) {
            if (startNodeLabelId == -1) break;
            long[] lArray3 = this.counts[startNodeLabelId][this.anyRelationshipType];
            int n3 = this.anyLabel;
            lArray3[n3] = lArray3[n3] + 1L;
            long[] lArray4 = this.counts[startNodeLabelId][type];
            int n4 = this.anyLabel;
            lArray4[n4] = lArray4[n4] + 1L;
            for (int endNodeLabelId : this.endScratch = this.nodeLabelCache.get(endNode, this.endScratch)) {
                if (endNodeLabelId == -1) break;
                long[] lArray5 = this.counts[startNodeLabelId][this.anyRelationshipType];
                int n5 = endNodeLabelId;
                lArray5[n5] = lArray5[n5] + 1L;
                long[] lArray6 = this.counts[startNodeLabelId][type];
                int n6 = endNodeLabelId;
                lArray6[n6] = lArray6[n6] + 1L;
            }
        }
        this.endScratch = this.nodeLabelCache.get(endNode, this.endScratch);
        for (int endNodeLabelId : this.endScratch) {
            if (endNodeLabelId == -1) break;
            long[] lArray7 = this.counts[this.anyLabel][this.anyRelationshipType];
            int n7 = endNodeLabelId;
            lArray7[n7] = lArray7[n7] + 1L;
            long[] lArray8 = this.counts[this.anyLabel][type];
            int n8 = endNodeLabelId;
            lArray8[n8] = lArray8[n8] + 1L;
        }
    }

    @Override
    public boolean process(RelationshipRecord record) {
        this.process(record.getFirstNode(), record.getType(), record.getSecondNode());
        return false;
    }

    @Override
    public void done() {
        for (int startNodeLabelId = 0; startNodeLabelId < this.counts.length; ++startNodeLabelId) {
            long[][] types = this.counts[startNodeLabelId];
            for (int typeId = 0; typeId < types.length; ++typeId) {
                long[] endNodeLabelIds = types[typeId];
                for (int endNodeLabelId = 0; endNodeLabelId < endNodeLabelIds.length; ++endNodeLabelId) {
                    if (startNodeLabelId != this.anyLabel && endNodeLabelId != this.anyLabel) continue;
                    int startLabel = startNodeLabelId == this.anyLabel ? -1 : startNodeLabelId;
                    int type = typeId == this.anyRelationshipType ? -1 : typeId;
                    int endLabel = endNodeLabelId == this.anyLabel ? -1 : endNodeLabelId;
                    long count = endNodeLabelIds[endNodeLabelId];
                    this.countsUpdater.incrementRelationshipCount(startLabel, type, endLabel, count);
                }
            }
        }
    }
}

