/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.unsafe.impl.batchimport.RecordProcessor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class RecordProcessorStep<T extends AbstractBaseRecord>
extends ExecutorServiceStep<T[]> {
    private final RecordProcessor<T> processor;
    private final boolean endOfLine;

    public RecordProcessorStep(StageControl control, String name, int workAheadSize, int movingAverageSize, RecordProcessor<T> processor, boolean endOfLine) {
        super(control, name, workAheadSize, movingAverageSize, 1);
        this.processor = processor;
        this.endOfLine = endOfLine;
    }

    @Override
    protected Object process(long ticket, T[] batch) {
        for (T item : batch) {
            if (item == null) continue;
            this.processor.process(item);
        }
        return this.endOfLine ? null : batch;
    }

    @Override
    protected void done() {
        super.done();
        this.processor.done();
    }
}

