/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsProcessor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ProcessRelationshipCountsDataStep
extends ExecutorServiceStep<long[]> {
    private final NodeLabelsCache cache;
    private final Map<Thread, RelationshipCountsProcessor> processors = new ConcurrentHashMap<Thread, RelationshipCountsProcessor>();
    private final int highLabelId;
    private final int highRelationshipTypeId;
    private final CountsAccessor.Updater countsUpdater;

    public ProcessRelationshipCountsDataStep(StageControl control, NodeLabelsCache cache, int workAheadSize, int movingAverageSize, int highLabelId, int highRelationshipTypeId, CountsAccessor.Updater countsUpdater) {
        super(control, "COUNT", workAheadSize, movingAverageSize, 1, true);
        this.cache = cache;
        this.highLabelId = highLabelId;
        this.highRelationshipTypeId = highRelationshipTypeId;
        this.countsUpdater = countsUpdater;
    }

    @Override
    protected Object process(long ticket, long[] batch) {
        RelationshipCountsProcessor processor = this.processor();
        for (int i = 0; i < batch.length; ++i) {
            processor.process(batch[i++], (int)batch[i++], batch[i]);
        }
        return null;
    }

    private RelationshipCountsProcessor processor() {
        RelationshipCountsProcessor processor = this.processors.get(Thread.currentThread());
        if (processor == null) {
            processor = new RelationshipCountsProcessor(this.cache, this.highLabelId, this.highRelationshipTypeId, this.countsUpdater);
            this.processors.put(Thread.currentThread(), processor);
        }
        return processor;
    }

    @Override
    protected void done() {
        super.done();
        for (RelationshipCountsProcessor processor : this.processors.values()) {
            processor.done();
        }
    }
}

