/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import org.neo4j.function.Function;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Format;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.BatchImporter;
import org.neo4j.unsafe.impl.batchimport.CalculateDenseNodesStep;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.EntityStoreUpdaterStep;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.NodeCountsStage;
import org.neo4j.unsafe.impl.batchimport.NodeEncoderStep;
import org.neo4j.unsafe.impl.batchimport.NodeFirstRelationshipStage;
import org.neo4j.unsafe.impl.batchimport.PropertyEncoderStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipEncoderStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkbackStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipPreparationStep;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.WriterFactories;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLinkImpl;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.staging.InputIteratorBatcherStep;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStore;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPageCache;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class ParallelBatchImporter
implements BatchImporter {
    private final String storeDir;
    private final FileSystemAbstraction fileSystem;
    private final Configuration config;
    private final IoMonitor writeMonitor;
    private final Logging logging;
    private final StringLogger logger;
    private final ExecutionMonitor executionMonitor;
    private final Monitors monitors;
    private final BatchingPageCache.WriterFactory writerFactory;
    private final AdditionalInitialIds additionalInitialIds;

    public ParallelBatchImporter(String storeDir, FileSystemAbstraction fileSystem, Configuration config, Logging logging, ExecutionMonitor executionMonitor, Function<Configuration, BatchingPageCache.WriterFactory> writerFactory, AdditionalInitialIds additionalInitialIds) {
        this.storeDir = storeDir;
        this.fileSystem = fileSystem;
        this.config = config;
        this.logging = logging;
        this.executionMonitor = executionMonitor;
        this.additionalInitialIds = additionalInitialIds;
        this.logger = logging.getMessagesLog(this.getClass());
        this.monitors = new Monitors();
        this.writeMonitor = new IoMonitor();
        this.writerFactory = (BatchingPageCache.WriterFactory)writerFactory.apply((Object)config);
    }

    public ParallelBatchImporter(String storeDir, Configuration config, Logging logging, ExecutionMonitor executionMonitor) {
        this(storeDir, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), config, logging, executionMonitor, WriterFactories.parallel(), AdditionalInitialIds.EMPTY);
    }

    @Override
    public void doImport(Input input) throws IOException {
        this.logger.info("Import starting");
        NodeRelationshipLink nodeRelationshipLink = null;
        NodeLabelsCache nodeLabelsCache = null;
        long startTime = System.currentTimeMillis();
        File badRelationshipsFile = new File(this.config.badFileName());
        boolean hasBadRelationships = false;
        try (BatchingNeoStore neoStore = new BatchingNeoStore(this.fileSystem, this.storeDir, this.config, this.writeMonitor, this.logging, this.monitors, this.writerFactory, this.additionalInitialIds);
             BufferedOutputStream badRelationshipsOutput = new BufferedOutputStream(this.fileSystem.openAsOutputStream(badRelationshipsFile, false));
             Collector<InputRelationship> badRelationships = input.badRelationshipsCollector(badRelationshipsOutput);
             CountsAccessor.Updater countsUpdater = neoStore.getCountsStore().reset();){
            IdMapper idMapper = input.idMapper();
            IdGenerator idGenerator = input.idGenerator();
            nodeRelationshipLink = new NodeRelationshipLinkImpl(NumberArrayFactory.AUTO, this.config.denseNodeThreshold());
            InputIterable<InputNode> nodes = input.nodes();
            InputIterable<InputRelationship> relationships = input.relationships();
            NodeStage nodeStage = new NodeStage(nodes, idMapper, idGenerator, neoStore);
            CalculateDenseNodesStage calculateDenseNodesStage = new CalculateDenseNodesStage(relationships, nodeRelationshipLink, idMapper, badRelationships);
            if (idMapper.needsPreparation()) {
                this.executeStages(nodeStage);
                this.executeStages(calculateDenseNodesStage);
            } else {
                this.executeStages(nodeStage, calculateDenseNodesStage);
            }
            RelationshipStage relationshipStage = new RelationshipStage(relationships, idMapper, neoStore, nodeRelationshipLink, input.specificRelationshipIds());
            this.executeStages(relationshipStage);
            neoStore.flush();
            this.writerFactory.awaitEverythingWritten();
            nodeLabelsCache = new NodeLabelsCache(NumberArrayFactory.AUTO, neoStore.getLabelRepository().getHighId());
            this.executeStages(new NodeFirstRelationshipStage(this.config, neoStore.getNodeStore(), neoStore.getRelationshipGroupStore(), nodeRelationshipLink));
            nodeRelationshipLink.clearRelationships();
            this.executeStages(new RelationshipLinkbackStage(this.config, neoStore.getRelationshipStore(), nodeRelationshipLink));
            nodeRelationshipLink.close();
            nodeRelationshipLink = null;
            this.executeStages(new NodeCountsStage(this.config, nodeLabelsCache, neoStore.getNodeStore(), neoStore.getLabelRepository().getHighId(), countsUpdater));
            this.executeStages(new RelationshipCountsStage(this.config, nodeLabelsCache, neoStore.getRelationshipStore(), neoStore.getLabelRepository().getHighId(), neoStore.getRelationshipTypeRepository().getHighId(), countsUpdater));
            long totalTimeMillis = System.currentTimeMillis() - startTime;
            this.executionMonitor.done(totalTimeMillis);
            this.logger.info("Import completed, took " + Format.duration(totalTimeMillis));
            boolean bl = hasBadRelationships = badRelationships.badEntries() > 0;
            if (hasBadRelationships) {
                this.logger.warn("There were " + badRelationships.badEntries() + " bad relationships which were skipped " + "and logged into " + badRelationshipsFile.getAbsolutePath());
            }
        }
        catch (Throwable t) {
            this.logger.error("Error during import", t);
            throw Exceptions.launderedException(IOException.class, t);
        }
        finally {
            this.writerFactory.shutdown();
            if (nodeRelationshipLink != null) {
                nodeRelationshipLink.close();
            }
            if (nodeLabelsCache != null) {
                nodeLabelsCache.close();
            }
            if (!hasBadRelationships) {
                this.fileSystem.deleteFile(badRelationshipsFile);
            }
        }
    }

    private void executeStages(Stage ... stages) {
        ExecutionSupervisors.superviseDynamicExecution(this.executionMonitor, this.config, stages);
    }

    public class RelationshipStage
    extends Stage {
        public RelationshipStage(InputIterable<InputRelationship> relationships, IdMapper idMapper, BatchingNeoStore neoStore, NodeRelationshipLink nodeRelationshipLink, boolean specificIds) {
            super("Relationships", ParallelBatchImporter.this.config, false);
            this.add(new InputIteratorBatcherStep<InputRelationship>(this.control(), ParallelBatchImporter.this.config.batchSize(), ParallelBatchImporter.this.config.movingAverageSize(), relationships.iterator(), InputRelationship.class));
            RelationshipStore relationshipStore = neoStore.getRelationshipStore();
            PropertyStore propertyStore = neoStore.getPropertyStore();
            this.add(new RelationshipPreparationStep(this.control(), ParallelBatchImporter.this.config, idMapper));
            this.add(new PropertyEncoderStep(this.control(), ParallelBatchImporter.this.config, 1, neoStore.getPropertyKeyRepository(), propertyStore));
            this.add(new RelationshipEncoderStep(this.control(), ParallelBatchImporter.this.config, neoStore.getRelationshipTypeRepository(), relationshipStore, nodeRelationshipLink, specificIds));
            this.add(new EntityStoreUpdaterStep(this.control(), ParallelBatchImporter.this.config, relationshipStore, propertyStore, ParallelBatchImporter.this.writeMonitor, ParallelBatchImporter.this.writerFactory));
        }
    }

    public class CalculateDenseNodesStage
    extends Stage {
        public CalculateDenseNodesStage(InputIterable<InputRelationship> relationships, NodeRelationshipLink nodeRelationshipLink, IdMapper idMapper, Collector<InputRelationship> badRelationshipsCollector) {
            super("Calculate dense nodes", ParallelBatchImporter.this.config, false);
            this.add(new InputIteratorBatcherStep<InputRelationship>(this.control(), ParallelBatchImporter.this.config.batchSize(), ParallelBatchImporter.this.config.movingAverageSize(), relationships.iterator(), InputRelationship.class));
            this.add(new RelationshipPreparationStep(this.control(), ParallelBatchImporter.this.config, idMapper));
            this.add(new CalculateDenseNodesStep(this.control(), ParallelBatchImporter.this.config, nodeRelationshipLink, badRelationshipsCollector));
        }
    }

    public class NodeStage
    extends Stage {
        public NodeStage(InputIterable<InputNode> nodes, IdMapper idMapper, IdGenerator idGenerator, BatchingNeoStore neoStore) {
            super("Nodes", ParallelBatchImporter.this.config, idGenerator.dependsOnInput());
            this.add(new InputIteratorBatcherStep<InputNode>(this.control(), ParallelBatchImporter.this.config.batchSize(), ParallelBatchImporter.this.config.movingAverageSize(), nodes.iterator(), InputNode.class));
            NodeStore nodeStore = neoStore.getNodeStore();
            PropertyStore propertyStore = neoStore.getPropertyStore();
            this.add(new PropertyEncoderStep(this.control(), ParallelBatchImporter.this.config, 1, neoStore.getPropertyKeyRepository(), propertyStore));
            this.add(new NodeEncoderStep(this.control(), ParallelBatchImporter.this.config, idMapper, idGenerator, neoStore.getLabelRepository(), nodeStore, Utils.idsOf(nodes)));
            this.add(new EntityStoreUpdaterStep(this.control(), ParallelBatchImporter.this.config, nodeStore, propertyStore, ParallelBatchImporter.this.writeMonitor, ParallelBatchImporter.this.writerFactory));
        }
    }
}

