/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.unsafe.impl.batchimport.NodeFirstRelationshipProcessor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class NodeFirstRelationshipStep
extends ExecutorServiceStep<NodeRecord[]> {
    private final NodeFirstRelationshipProcessor processor;

    public NodeFirstRelationshipStep(StageControl control, int workAheadSize, int movingAverageSize, RelationshipGroupStore relationshipGroupStore, NodeRelationshipLink cache) {
        super(control, "Node --> Relationship", workAheadSize, movingAverageSize, 1);
        this.processor = new NodeFirstRelationshipProcessor(relationshipGroupStore, cache);
    }

    @Override
    protected Object process(long ticket, NodeRecord[] batch) {
        for (NodeRecord node : batch) {
            if (node == null) continue;
            this.processor.process(node);
        }
        return batch;
    }
}

