/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.NodeFirstRelationshipProcessor;
import org.neo4j.unsafe.impl.batchimport.ReadNodeRecordsStep;
import org.neo4j.unsafe.impl.batchimport.RecordProcessorStep;
import org.neo4j.unsafe.impl.batchimport.UpdateRecordsStep;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;

public class NodeFirstRelationshipStage
extends Stage {
    public NodeFirstRelationshipStage(Configuration config, NodeStore nodeStore, RelationshipGroupStore relationshipGroupStore, NodeRelationshipLink cache) {
        super("Node --> Relationship", config, false);
        this.add(new ReadNodeRecordsStep(this.control(), config.batchSize(), config.movingAverageSize(), nodeStore));
        this.add(new RecordProcessorStep<NodeRecord>(this.control(), "LINK", config.workAheadSize(), config.movingAverageSize(), new NodeFirstRelationshipProcessor(relationshipGroupStore, cache), false));
        this.add(new UpdateRecordsStep<NodeRecord>(this.control(), config.workAheadSize(), config.movingAverageSize(), nodeStore));
    }
}

