/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class CalculateDenseNodesStep
extends ExecutorServiceStep<Batch<InputRelationship, RelationshipRecord>> {
    private final NodeRelationshipLink nodeRelationshipLink;
    private final Collector<InputRelationship> badRelationshipsCollector;

    public CalculateDenseNodesStep(StageControl control, Configuration config, NodeRelationshipLink nodeRelationshipLink, Collector<InputRelationship> badRelationshipsCollector) {
        super(control, "CALCULATOR", config.workAheadSize(), config.movingAverageSize(), 1);
        this.nodeRelationshipLink = nodeRelationshipLink;
        this.badRelationshipsCollector = badRelationshipsCollector;
    }

    @Override
    protected Object process(long ticket, Batch<InputRelationship, RelationshipRecord> batch) {
        InputRelationship[] input = (InputRelationship[])batch.input;
        long[] ids = batch.ids;
        for (int i = 0; i < input.length; ++i) {
            InputRelationship rel = input[i];
            long startNode = ids[i * 2];
            long endNode = ids[i * 2 + 1];
            this.incrementCount(rel, startNode, rel.startNode());
            if (startNode == endNode) continue;
            this.incrementCount(rel, endNode, rel.endNode());
        }
        return null;
    }

    private void incrementCount(InputRelationship relationship, long nodeId, Object inputNodeId) {
        if (nodeId != -1L) {
            try {
                this.nodeRelationshipLink.incrementCount(nodeId);
                return;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        this.badRelationshipsCollector.collect(relationship, inputNodeId);
    }
}

