/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.function;

import org.neo4j.function.Function;
import org.neo4j.kernel.impl.util.function.Optional;

public class Optionals {
    private static final Optional NONE = new Optional(){

        public Object get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        public Optional or(Optional secondChoice) {
            return secondChoice;
        }

        public Optional or(Object secondChoice) {
            return Optionals.some(secondChoice);
        }

        public Optional map(Function conversion) {
            return this;
        }
    };

    public static <TYPE> Optional<TYPE> none() {
        return NONE;
    }

    public static <TYPE> Optional<TYPE> some(final TYPE obj) {
        return new Optional<TYPE>(){

            @Override
            public TYPE get() {
                return obj;
            }

            @Override
            public boolean isPresent() {
                return true;
            }

            @Override
            public Optional<TYPE> or(Optional<TYPE> secondChoice) {
                return this;
            }

            @Override
            public Optional<TYPE> or(TYPE secondChoice) {
                return this;
            }

            @Override
            public <To> Optional<To> map(Function<TYPE, ? extends To> conversion) {
                return Optionals.some(conversion.apply(obj));
            }
        };
    }
}

