/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Collection;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;

public class PropertyLoader {
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final PropertyStore propertyStore;
    private final NeoStore neoStore;

    public PropertyLoader(NeoStore neoStore) {
        this.neoStore = neoStore;
        this.nodeStore = neoStore.getNodeStore();
        this.relationshipStore = neoStore.getRelationshipStore();
        this.propertyStore = neoStore.getPropertyStore();
    }

    public void nodeLoadProperties(long nodeId, TransactionRecordState.PropertyReceiver receiver) {
        NodeRecord nodeRecord = this.nodeStore.getRecord(nodeId);
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Node[" + nodeId + "] has been deleted in this tx");
        }
        this.loadProperties(nodeRecord.getNextProp(), receiver);
    }

    public void relLoadProperties(long relId, TransactionRecordState.PropertyReceiver receiver) {
        RelationshipRecord relRecord = this.relationshipStore.getRecord(relId);
        if (!relRecord.inUse()) {
            throw new InvalidRecordException("Relationship[" + relId + "] not in use");
        }
        this.loadProperties(relRecord.getNextProp(), receiver);
    }

    public void graphLoadProperties(TransactionRecordState.PropertyReceiver records) {
        this.loadProperties(this.neoStore.asRecord().getNextProp(), records);
    }

    private void loadProperties(long nextProp, TransactionRecordState.PropertyReceiver receiver) {
        Collection<PropertyRecord> chain = this.propertyStore.getPropertyRecordChain(nextProp);
        if (chain != null) {
            this.loadPropertyChain(chain, receiver);
        }
    }

    private void loadPropertyChain(Collection<PropertyRecord> chain, TransactionRecordState.PropertyReceiver receiver) {
        if (chain != null) {
            for (PropertyRecord propRecord : chain) {
                for (PropertyBlock propBlock : propRecord) {
                    receiver.receive(propBlock.newPropertyData(this.propertyStore), propRecord.getId());
                }
            }
        }
    }
}

