/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.index.IndexUpdates;
import org.neo4j.kernel.impl.api.index.UpdateMode;
import org.neo4j.kernel.impl.core.IteratingPropertyReceiver;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.state.LabelChangeSummary;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;

public class LazyIndexUpdates
implements IndexUpdates {
    private final NodeStore nodeStore;
    private final PropertyStore propertyStore;
    private final Map<Long, List<Command.PropertyCommand>> propCommands;
    private final Map<Long, Command.NodeCommand> nodeCommands;
    private Collection<NodePropertyUpdate> updates;
    private final PropertyLoader propertyLoader;

    public LazyIndexUpdates(NodeStore nodeStore, PropertyStore propertyStore, Map<Long, List<Command.PropertyCommand>> propCommands, Map<Long, Command.NodeCommand> nodeCommands, PropertyLoader propertyLoader) {
        this.nodeStore = nodeStore;
        this.propertyStore = propertyStore;
        this.propCommands = propCommands;
        this.nodeCommands = nodeCommands;
        this.propertyLoader = propertyLoader;
    }

    @Override
    public Iterator<NodePropertyUpdate> iterator() {
        if (this.updates == null) {
            this.updates = this.gatherPropertyAndLabelUpdates();
        }
        return this.updates.iterator();
    }

    @Override
    public Set<Long> changedNodeIds() {
        HashSet<Long> nodeIds = new HashSet<Long>(this.nodeCommands.keySet());
        nodeIds.addAll(this.propCommands.keySet());
        return nodeIds;
    }

    private Collection<NodePropertyUpdate> gatherPropertyAndLabelUpdates() {
        HashSet<NodePropertyUpdate> propertyUpdates = new HashSet<NodePropertyUpdate>();
        HashMap<Pair<Long, Integer>, NodePropertyUpdate> propertyChanges = new HashMap<Pair<Long, Integer>, NodePropertyUpdate>();
        this.gatherUpdatesFromPropertyCommands(propertyUpdates, propertyChanges);
        this.gatherUpdatesFromNodeCommands(propertyUpdates, propertyChanges);
        return propertyUpdates;
    }

    private void gatherUpdatesFromPropertyCommands(Collection<NodePropertyUpdate> updates, Map<Pair<Long, Integer>, NodePropertyUpdate> propertyLookup) {
        for (Map.Entry<Long, List<Command.PropertyCommand>> entry : this.propCommands.entrySet()) {
            long[] nodeLabelsAfter;
            long[] nodeLabelsBefore;
            long nodeId = entry.getKey();
            Command.NodeCommand nodeChanges = this.nodeCommands.get(nodeId);
            if (nodeChanges != null) {
                nodeLabelsBefore = NodeLabelsField.parseLabelsField(nodeChanges.getBefore()).get(this.nodeStore);
                nodeLabelsAfter = NodeLabelsField.parseLabelsField(nodeChanges.getAfter()).get(this.nodeStore);
            } else {
                NodeRecord nodeRecord = this.nodeStore.getRecord(nodeId);
                nodeLabelsBefore = nodeLabelsAfter = NodeLabelsField.parseLabelsField(nodeRecord).get(this.nodeStore);
            }
            this.propertyStore.toLogicalUpdates(updates, Iterables.cast((Iterable)entry.getValue()), nodeLabelsBefore, nodeLabelsAfter);
        }
        for (NodePropertyUpdate update : updates) {
            if (update.getUpdateMode() != UpdateMode.CHANGED) continue;
            propertyLookup.put(Pair.of(update.getNodeId(), update.getPropertyKeyId()), update);
        }
    }

    private void gatherUpdatesFromNodeCommands(Collection<NodePropertyUpdate> propertyUpdates, Map<Pair<Long, Integer>, NodePropertyUpdate> propertyLookup) {
        for (Command.NodeCommand nodeCommand : this.nodeCommands.values()) {
            long nodeId = nodeCommand.getKey();
            long[] labelsBefore = NodeLabelsField.parseLabelsField(nodeCommand.getBefore()).get(this.nodeStore);
            long[] labelsAfter = NodeLabelsField.parseLabelsField(nodeCommand.getAfter()).get(this.nodeStore);
            if (nodeCommand.getMode() == Command.Mode.DELETE) continue;
            LabelChangeSummary summary = new LabelChangeSummary(labelsBefore, labelsAfter);
            Iterator<DefinedProperty> properties = this.nodeFullyLoadProperties(nodeId);
            while (properties.hasNext()) {
                DefinedProperty property = properties.next();
                int propertyKeyId = property.propertyKeyId();
                if (summary.hasAddedLabels()) {
                    Object value = property.value();
                    propertyUpdates.add(NodePropertyUpdate.add(nodeId, propertyKeyId, value, summary.getAddedLabels()));
                }
                if (!summary.hasRemovedLabels()) continue;
                NodePropertyUpdate propertyChange = propertyLookup.get(Pair.of(nodeId, propertyKeyId));
                Object value = propertyChange == null ? property.value() : propertyChange.getValueBefore();
                propertyUpdates.add(NodePropertyUpdate.remove(nodeId, propertyKeyId, value, summary.getRemovedLabels()));
            }
        }
    }

    private Iterator<DefinedProperty> nodeFullyLoadProperties(long nodeId) {
        IteratingPropertyReceiver receiver = new IteratingPropertyReceiver();
        this.propertyLoader.nodeLoadProperties(nodeId, receiver);
        return receiver;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyIndexUpdates that = (LazyIndexUpdates)o;
        if (this.nodeCommands != null ? !this.nodeCommands.equals(that.nodeCommands) : that.nodeCommands != null) {
            return false;
        }
        if (this.nodeStore != null ? !this.nodeStore.equals(that.nodeStore) : that.nodeStore != null) {
            return false;
        }
        if (this.propCommands != null ? !this.propCommands.equals(that.propCommands) : that.propCommands != null) {
            return false;
        }
        if (this.propertyLoader != null ? !this.propertyLoader.equals(that.propertyLoader) : that.propertyLoader != null) {
            return false;
        }
        if (this.propertyStore != null ? !this.propertyStore.equals(that.propertyStore) : that.propertyStore != null) {
            return false;
        }
        return !(this.updates != null ? !this.updates.equals(that.updates) : that.updates != null);
    }

    public int hashCode() {
        int result = this.nodeStore != null ? this.nodeStore.hashCode() : 0;
        result = 31 * result + (this.propertyStore != null ? this.propertyStore.hashCode() : 0);
        result = 31 * result + (this.propCommands != null ? this.propCommands.hashCode() : 0);
        result = 31 * result + (this.nodeCommands != null ? this.nodeCommands.hashCode() : 0);
        result = 31 * result + (this.updates != null ? this.updates.hashCode() : 0);
        result = 31 * result + (this.propertyLoader != null ? this.propertyLoader.hashCode() : 0);
        return result;
    }
}

